/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.mirror.Mirror;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.File;

final class MirroringTask {
    private final MeterRegistry meterRegistry;
    private final Mirror mirror;
    private final Iterable<Tag> tags;

    private static Iterable<Tag> generateTags(Mirror mirror) {
        return ImmutableList.of((Object)Tag.of((String)"direction", (String)mirror.direction().name()), (Object)Tag.of((String)"remoteBranch", (String)((String)MoreObjects.firstNonNull((Object)mirror.remoteBranch(), (Object)""))), (Object)Tag.of((String)"remotePath", (String)mirror.remotePath()), (Object)Tag.of((String)"localRepo", (String)mirror.localRepo().name()), (Object)Tag.of((String)"localPath", (String)mirror.localPath()));
    }

    MirroringTask(Mirror mirror, MeterRegistry meterRegistry) {
        this.mirror = mirror;
        this.meterRegistry = meterRegistry;
        this.tags = MirroringTask.generateTags(mirror);
    }

    private Counter counter(boolean success) {
        return Counter.builder((String)"mirroring.result").tags(this.tags).tag("success", Boolean.toString(success)).register(this.meterRegistry);
    }

    void run(File workDir, CommandExecutor executor, int maxNumFiles, long maxNumBytes) {
        try {
            this.meterRegistry.timer("mirroring.task", this.tags).record(() -> this.mirror.mirror(workDir, executor, maxNumFiles, maxNumBytes));
            this.counter(true).increment();
        }
        catch (Exception e) {
            this.counter(false).increment();
            throw e;
        }
    }
}

