/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.Session;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.internal.mirror.GitMirror;
import com.linecorp.centraldogma.server.internal.mirror.GitWithAuth;
import com.linecorp.centraldogma.server.internal.mirror.credential.PasswordMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.PublicKeyMirrorCredential;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;

final class Git5WithAuth
extends GitWithAuth {
    private static final OpenSshConfig EMPTY_CONFIG = Git5WithAuth.emptySshConfig();
    @Nullable
    private static final Method SET_CONFIG_METHOD;

    Git5WithAuth(GitMirror mirror, File repoDir) throws IOException {
        super(mirror, repoDir);
    }

    @Override
    FetchCommand fetch(int depth) {
        return this.fetch();
    }

    @Override
    public <T extends TransportCommand<?, ?>> void configureSsh(T cmd, final PublicKeyMirrorCredential cred) {
        cmd.setTransportConfigCallback(transport -> {
            SshTransport sshTransport = (SshTransport)transport;
            JschConfigSessionFactory sessionFactory = new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host host, Session session) {
                    try {
                        session.setHostKeyRepository((HostKeyRepository)new GitWithAuth.MirrorHostKeyRepository(Git5WithAuth.this.getMirror().localRepo().parent().metaRepo()));
                        session.setIdentityRepository((IdentityRepository)new GitWithAuth.MirrorIdentityRepository(cred.username() + '@' + host.getHostName(), cred));
                    }
                    catch (MirrorException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new MirrorException(e);
                    }
                }
            };
            Git5WithAuth.setEmptyConfig(sessionFactory);
            sshTransport.setSshSessionFactory((SshSessionFactory)sessionFactory);
        });
    }

    @Override
    public <T extends TransportCommand<?, ?>> void configureSsh(T cmd, final PasswordMirrorCredential cred) {
        cmd.setTransportConfigCallback(transport -> {
            SshTransport sshTransport = (SshTransport)transport;
            JschConfigSessionFactory sessionFactory = new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host host, Session session) {
                    try {
                        session.setHostKeyRepository((HostKeyRepository)new GitWithAuth.MirrorHostKeyRepository(Git5WithAuth.this.getMirror().localRepo().parent().metaRepo()));
                        session.setPassword(cred.password());
                    }
                    catch (MirrorException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new MirrorException(e);
                    }
                }
            };
            Git5WithAuth.setEmptyConfig(sessionFactory);
            sshTransport.setSshSessionFactory((SshSessionFactory)sessionFactory);
        });
    }

    private static void setEmptyConfig(JschConfigSessionFactory sessionFactory) {
        try {
            if (SET_CONFIG_METHOD != null) {
                SET_CONFIG_METHOD.invoke((Object)sessionFactory, EMPTY_CONFIG);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static OpenSshConfig emptySshConfig() {
        File emptyConfigFile;
        try {
            emptyConfigFile = File.createTempFile("dogma", "empty-ssh-config");
            emptyConfigFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            Constructor ctor = OpenSshConfig.class.getDeclaredConstructor(File.class, File.class);
            ctor.setAccessible(true);
            return (OpenSshConfig)ctor.newInstance(emptyConfigFile.getParentFile(), emptyConfigFile);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        Method setConfigMethod = null;
        try {
            setConfigMethod = JschConfigSessionFactory.class.getDeclaredMethod("setConfig", OpenSshConfig.class);
            setConfigMethod.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SET_CONFIG_METHOD = setConfigMethod;
    }
}

