/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergeSource;
import com.linecorp.centraldogma.internal.shaded.guava.base.Splitter;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.lang.reflect.ParameterizedType;
import javax.annotation.Nullable;

public class MergeQueryRequestConverter
implements RequestConverterFunction {
    private static final Splitter querySplitter = Splitter.on((char)'&').trimResults().omitEmptyStrings();

    public MergeQuery<?> convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType, @Nullable ParameterizedType expectedParameterizedResultType) throws Exception {
        String queryString = ctx.query();
        if (queryString != null) {
            String decodedString = QueryStringDecoder.decodeComponent((String)queryString);
            Iterable queries = querySplitter.split((CharSequence)decodedString);
            ImmutableList.Builder mergeSourceBuilder = ImmutableList.builder();
            ImmutableList.Builder jsonPathsBuilder = ImmutableList.builder();
            for (String query : queries) {
                int index = query.indexOf(61);
                if (index < 0) continue;
                String key = query.substring(0, index);
                String value = query.substring(index + 1);
                switch (key) {
                    case "path": {
                        mergeSourceBuilder.add((Object)MergeSource.ofRequired((String)value));
                        break;
                    }
                    case "optional_path": {
                        mergeSourceBuilder.add((Object)MergeSource.ofOptional((String)value));
                        break;
                    }
                    case "jsonpath": {
                        jsonPathsBuilder.add((Object)value);
                    }
                }
            }
            return MergeQuery.ofJsonPath((Iterable)mergeSourceBuilder.build(), (Iterable)jsonPathsBuilder.build());
        }
        return (MergeQuery)RequestConverterFunction.fallthrough();
    }
}

