/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.dto;

import com.linecorp.centraldogma.internal.thrift.SchemaEntry;
import com.linecorp.centraldogma.server.internal.admin.dto.CommentDto;
import com.linecorp.centraldogma.server.internal.admin.dto.PropertyFilterDto;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaEntryDto {
    private String repositoryName;
    private String path;
    private PropertyFilterDto propertyFilter;
    private List<String> types;
    private CommentDto comment;

    public SchemaEntryDto() {
    }

    public SchemaEntryDto(SchemaEntry schemaEntry) {
        this.repositoryName = schemaEntry.getRepositoryName();
        this.path = schemaEntry.getPath();
        this.propertyFilter = new PropertyFilterDto(schemaEntry.getPropertyFilter());
        this.types = schemaEntry.getTypes().stream().map(Enum::name).collect(Collectors.toList());
        if (schemaEntry.getComment() != null) {
            this.comment = new CommentDto(schemaEntry.getComment());
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PropertyFilterDto getPropertyFilter() {
        return this.propertyFilter;
    }

    public void setPropertyFilter(PropertyFilterDto propertyFilter) {
        this.propertyFilter = propertyFilter;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public CommentDto getComment() {
        return this.comment;
    }

    public void setComment(CommentDto comment) {
        this.comment = comment;
    }
}

