/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Base64;

public final class RawSessionJsonDeserializer
extends StdDeserializer<Serializable> {
    private static final long serialVersionUID = 6711539370106208875L;

    public RawSessionJsonDeserializer() {
        super(Serializable.class);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Serializable deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode((String)p.readValueAs(String.class)));){
            Serializable serializable;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                serializable = (Serializable)ois.readObject();
            }
            return serializable;
        }
        catch (ClassNotFoundException e) {
            ctxt.reportInputMismatch(Serializable.class, "failed to deserialize a raw session: " + e, new Object[0]);
            throw new Error();
        }
    }
}

