/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import org.apache.curator.shaded.com.google.common.base.Preconditions;

public final class QuotaConfig {
    private final int requestQuota;
    private final int timeWindowSeconds;

    @JsonCreator
    public QuotaConfig(@JsonProperty(value="requestQuota") int requestQuota, @JsonProperty(value="timeWindowSeconds") int timeWindowSeconds) {
        Preconditions.checkArgument((requestQuota > 0 ? 1 : 0) != 0, (String)"requestQuota: %s (expected: > 0)", (int)requestQuota);
        Preconditions.checkArgument((timeWindowSeconds > 0 ? 1 : 0) != 0, (String)"timeWindowSeconds: %s (expected: > 0)", (int)timeWindowSeconds);
        this.requestQuota = requestQuota;
        this.timeWindowSeconds = timeWindowSeconds;
    }

    @JsonProperty
    public int timeWindowSeconds() {
        return this.timeWindowSeconds;
    }

    @JsonProperty
    public int requestQuota() {
        return this.requestQuota;
    }

    public double permitsPerSecond() {
        return (double)this.requestQuota() * 1.0 / (double)this.timeWindowSeconds();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuotaConfig)) {
            return false;
        }
        QuotaConfig that = (QuotaConfig)o;
        return this.requestQuota == that.requestQuota && this.timeWindowSeconds == that.timeWindowSeconds;
    }

    public int hashCode() {
        return this.requestQuota * 31 + this.timeWindowSeconds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestQuota", this.requestQuota).add("timeWindowSeconds", this.timeWindowSeconds).toString();
    }
}

