/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.QuotaConfig;
import com.linecorp.centraldogma.server.metadata.Identifiable;
import com.linecorp.centraldogma.server.metadata.PerRolePermissions;
import com.linecorp.centraldogma.server.metadata.Permission;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RepositoryMetadata
implements Identifiable {
    private final String name;
    private final PerRolePermissions perRolePermissions;
    private final Map<String, Collection<Permission>> perUserPermissions;
    private final Map<String, Collection<Permission>> perTokenPermissions;
    private final UserAndTimestamp creation;
    @Nullable
    private final UserAndTimestamp removal;
    @Nullable
    private final QuotaConfig writeQuota;

    public RepositoryMetadata(String name, UserAndTimestamp creation, PerRolePermissions perRolePermissions) {
        this(name, perRolePermissions, (Map<String, Collection<Permission>>)ImmutableMap.of(), (Map<String, Collection<Permission>>)ImmutableMap.of(), creation, null, null);
    }

    @JsonCreator
    public RepositoryMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="perRolePermissions") PerRolePermissions perRolePermissions, @JsonProperty(value="perUserPermissions") Map<String, Collection<Permission>> perUserPermissions, @JsonProperty(value="perTokenPermissions") Map<String, Collection<Permission>> perTokenPermissions, @JsonProperty(value="creation") UserAndTimestamp creation, @JsonProperty(value="removal") @Nullable UserAndTimestamp removal, @JsonProperty(value="writeQuota") @Nullable QuotaConfig writeQuota) {
        this.name = Objects.requireNonNull(name, "name");
        this.perRolePermissions = Objects.requireNonNull(perRolePermissions, "perRolePermissions");
        this.perUserPermissions = ImmutableMap.copyOf(Objects.requireNonNull(perUserPermissions, "perUserPermissions"));
        this.perTokenPermissions = ImmutableMap.copyOf(Objects.requireNonNull(perTokenPermissions, "perTokenPermissions"));
        this.creation = Objects.requireNonNull(creation, "creation");
        this.removal = removal;
        this.writeQuota = writeQuota;
    }

    @Override
    public String id() {
        return this.name;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public PerRolePermissions perRolePermissions() {
        return this.perRolePermissions;
    }

    @JsonProperty
    public Map<String, Collection<Permission>> perUserPermissions() {
        return this.perUserPermissions;
    }

    @JsonProperty
    public Map<String, Collection<Permission>> perTokenPermissions() {
        return this.perTokenPermissions;
    }

    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp removal() {
        return this.removal;
    }

    @Nullable
    @JsonProperty(value="writeQuota")
    public QuotaConfig writeQuota() {
        return this.writeQuota;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name()).add("perRolePermissions", (Object)this.perRolePermissions()).add("perUserPermissions", this.perUserPermissions()).add("perTokenPermissions", this.perTokenPermissions()).add("creation", (Object)this.creation()).add("removal", (Object)this.removal()).add("writeQuota", (Object)this.writeQuota()).toString();
    }
}

