/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.thrift;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaException;
import com.linecorp.centraldogma.internal.thrift.ErrorCode;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CentralDogmaExceptions {
    private static final Logger logger = LoggerFactory.getLogger(CentralDogmaExceptions.class);

    static void log(String operationName, CentralDogmaException e) {
        RequestContext ctx = (RequestContext)RequestContext.mapCurrent(Function.identity(), () -> null);
        ErrorCode errorCode = e.getErrorCode();
        switch (errorCode) {
            case BAD_REQUEST: 
            case PROJECT_NOT_FOUND: 
            case PROJECT_EXISTS: 
            case REPOSITORY_NOT_FOUND: 
            case REPOSITORY_EXISTS: 
            case REVISION_NOT_FOUND: 
            case REVISION_EXISTS: 
            case ENTRY_NOT_FOUND: 
            case CHANGE_CONFLICT: 
            case QUERY_FAILURE: {
                if (!logger.isDebugEnabled()) break;
                if (ctx != null) {
                    logger.debug("{} Exception with error code {} ({}) from: {}()", new Object[]{ctx, errorCode, errorCode.getValue(), operationName, e});
                    break;
                }
                logger.debug("Exception with error code {} ({}) from: {}()", new Object[]{errorCode, errorCode.getValue(), operationName, e});
                break;
            }
            case REDUNDANT_CHANGE: 
            case SHUTTING_DOWN: {
                if (!logger.isDebugEnabled()) break;
                if (ctx != null) {
                    logger.debug("{} Exception with error code {} ({}) from: {}()", new Object[]{ctx, errorCode, errorCode.getValue(), operationName});
                    break;
                }
                logger.debug("Exception with error code {} ({}) from: {}()", new Object[]{errorCode, errorCode.getValue(), operationName});
                break;
            }
            default: {
                if (ctx != null) {
                    logger.warn("{} Unexpected exception with error code {} ({}) from: {}()", new Object[]{ctx, errorCode, errorCode.getValue(), operationName, e});
                    break;
                }
                logger.warn("Unexpected exception with error code {} ({}) from: {}()", new Object[]{errorCode, errorCode.getValue(), operationName, e});
            }
        }
    }

    private CentralDogmaExceptions() {
    }
}

