/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.CacheableCall;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryCache {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryCache.class);
    private final AsyncLoadingCache<CacheableCall, Object> cache;
    private final String cacheSpec;

    @Nullable
    public static String validateCacheSpec(@Nullable String cacheSpec) {
        if (cacheSpec == null) {
            return null;
        }
        try {
            CaffeineSpec.parse((String)cacheSpec);
            return cacheSpec;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("cacheSpec: " + cacheSpec + " (" + e.getMessage() + ')');
        }
    }

    public RepositoryCache(String cacheSpec, MeterRegistry meterRegistry) {
        this.cacheSpec = Objects.requireNonNull(RepositoryCache.validateCacheSpec(cacheSpec), "cacheSpec");
        Objects.requireNonNull(meterRegistry, "meterRegistry");
        Caffeine builder = Caffeine.from((String)cacheSpec);
        if (cacheSpec.contains("maximumWeight=")) {
            builder.weigher(CacheableCall::weigh);
        }
        this.cache = builder.recordStats().buildAsync((key, executor) -> {
            logger.debug("Cache miss: {}", key);
            return key.execute();
        });
        CaffeineCacheMetrics.monitor((MeterRegistry)meterRegistry, this.cache, (String)"repository", (String[])new String[0]);
    }

    public <T> CompletableFuture<T> get(CacheableCall<T> call) {
        Objects.requireNonNull(call, "call");
        CompletableFuture f = this.cache.get(call);
        return f;
    }

    @Nullable
    public <T> CompletableFuture<T> getIfPresent(CacheableCall<T> call) {
        Objects.requireNonNull(call, "call");
        CompletableFuture f = this.cache.getIfPresent(call);
        return f;
    }

    public <T> void put(CacheableCall<T> call, T value) {
        Objects.requireNonNull(call, "call");
        Objects.requireNonNull(value, "value");
        this.cache.put(call, CompletableFuture.completedFuture(value));
    }

    public CacheStats stats() {
        return this.cache.synchronous().stats();
    }

    public void clear() {
        this.cache.synchronous().invalidateAll();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("spec", (Object)this.cacheSpec).add("stats", (Object)this.stats()).toString();
    }
}

