/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.dto;

import com.linecorp.centraldogma.internal.thrift.PluginOperation;
import com.linecorp.centraldogma.server.internal.admin.dto.CommentDto;
import com.linecorp.centraldogma.server.internal.admin.dto.PluginOperationParamDefDto;
import com.linecorp.centraldogma.server.internal.admin.dto.PluginOperationReturnDefDto;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PluginOperationDto {
    private String pluginName;
    private String operationName;
    private List<PluginOperationParamDefDto> paramDefs = new ArrayList<PluginOperationParamDefDto>();
    private PluginOperationReturnDefDto returnDef;
    private CommentDto comment;

    public PluginOperationDto() {
    }

    public PluginOperationDto(PluginOperation pluginOperation) {
        this.pluginName = pluginOperation.getPluginName();
        this.operationName = pluginOperation.getOperationName();
        this.paramDefs = pluginOperation.getParamDefs().stream().map(PluginOperationParamDefDto::new).collect(Collectors.toList());
        this.returnDef = new PluginOperationReturnDefDto(pluginOperation.getReturnDef());
        if (pluginOperation.getComment() != null) {
            this.comment = new CommentDto(pluginOperation.getComment());
        }
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public List<PluginOperationParamDefDto> getParamDefs() {
        return this.paramDefs;
    }

    public void setParamDefs(List<PluginOperationParamDefDto> paramDefs) {
        this.paramDefs = paramDefs;
    }

    public PluginOperationReturnDefDto getReturnDef() {
        return this.returnDef;
    }

    public void setReturnDef(PluginOperationReturnDefDto returnDef) {
        this.returnDef = returnDef;
    }

    public CommentDto getComment() {
        return this.comment;
    }

    public void setComment(CommentDto comment) {
        this.comment = comment;
    }
}

