/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.metadata.Identifiable;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Token
implements Identifiable {
    private final String appId;
    @Nullable
    private final String secret;
    private final boolean isAdmin;
    private final UserAndTimestamp creation;
    @Nullable
    private final UserAndTimestamp deactivation;

    Token(String appId, String secret, boolean isAdmin, UserAndTimestamp creation) {
        this(appId, secret, isAdmin, creation, null);
    }

    @JsonCreator
    public Token(@JsonProperty(value="appId") String appId, @JsonProperty(value="secret") String secret, @JsonProperty(value="admin") boolean isAdmin, @JsonProperty(value="creation") UserAndTimestamp creation, @JsonProperty(value="deactivation") @Nullable UserAndTimestamp deactivation) {
        this.appId = Util.validateFileName((String)appId, (String)"appId");
        this.secret = Util.validateFileName((String)secret, (String)"secret");
        this.isAdmin = isAdmin;
        this.creation = Objects.requireNonNull(creation, "creation");
        this.deactivation = deactivation;
    }

    private Token(String appId, boolean isAdmin, UserAndTimestamp creation, @Nullable UserAndTimestamp deactivation) {
        this.appId = Util.validateFileName((String)appId, (String)"appId");
        this.isAdmin = isAdmin;
        this.creation = Objects.requireNonNull(creation, "creation");
        this.deactivation = deactivation;
        this.secret = null;
    }

    @Override
    public String id() {
        return this.appId;
    }

    @JsonProperty
    public String appId() {
        return this.appId;
    }

    @Nullable
    @JsonProperty
    public String secret() {
        return this.secret;
    }

    @JsonProperty
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @JsonProperty
    public UserAndTimestamp creation() {
        return this.creation;
    }

    @Nullable
    @JsonProperty
    public UserAndTimestamp deactivation() {
        return this.deactivation;
    }

    @JsonIgnore
    public boolean isActive() {
        return this.deactivation == null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this.appId()).add("isAdmin", this.isAdmin()).add("creation", (Object)this.creation()).add("deactivation", (Object)this.deactivation()).toString();
    }

    public Token withoutSecret() {
        return new Token(this.appId(), this.isAdmin(), this.creation(), this.deactivation());
    }
}

