/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.auth.RawSessionJsonDeserializer;
import com.linecorp.centraldogma.server.auth.RawSessionJsonSerializer;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Session {
    private static final long serialVersionUID = 4253152956820423809L;
    private final String id;
    private final String username;
    private final Instant creationTime;
    private final Instant expirationTime;
    @Nullable
    private final Serializable rawSession;

    public Session(String id, String username, Duration sessionValidDuration) {
        this.id = Objects.requireNonNull(id, "id");
        this.username = Objects.requireNonNull(username, "username");
        this.creationTime = Instant.now();
        this.expirationTime = this.creationTime.plus(Objects.requireNonNull(sessionValidDuration, "sessionValidDuration"));
        this.rawSession = null;
    }

    @JsonCreator
    public Session(@JsonProperty(value="id") String id, @JsonProperty(value="username") String username, @JsonProperty(value="creationTime") Instant creationTime, @JsonProperty(value="expirationTime") Instant expirationTime, @JsonProperty(value="rawSession") @JsonDeserialize(using=RawSessionJsonDeserializer.class) @Nullable Serializable rawSession) {
        this.id = Objects.requireNonNull(id, "id");
        this.username = Objects.requireNonNull(username, "username");
        this.creationTime = Objects.requireNonNull(creationTime, "creationTime");
        this.expirationTime = Objects.requireNonNull(expirationTime, "expirationTime");
        this.rawSession = rawSession;
    }

    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    public String username() {
        return this.username;
    }

    @JsonProperty
    public Instant creationTime() {
        return this.creationTime;
    }

    @JsonProperty
    public Instant expirationTime() {
        return this.expirationTime;
    }

    @Nullable
    @JsonProperty
    @JsonSerialize(using=RawSessionJsonSerializer.class)
    public Serializable rawSession() {
        return this.rawSession;
    }

    <T> T castRawSession() {
        return (T)Util.unsafeCast((Object)Objects.requireNonNull(this.rawSession, "rawSession"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("username", (Object)this.username).add("creationTime", (Object)this.creationTime).add("expirationTime", (Object)this.expirationTime).add("rawSession", this.rawSession != null ? this.rawSession.getClass().getSimpleName() : null).toString();
    }
}

