/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Path;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Splitter;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Maps;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.admin.dto.ChangeDto;
import com.linecorp.centraldogma.server.internal.admin.dto.CommitDto;
import com.linecorp.centraldogma.server.internal.admin.dto.CommitMessageDto;
import com.linecorp.centraldogma.server.internal.admin.dto.EntryDto;
import com.linecorp.centraldogma.server.internal.admin.dto.RevisionDto;
import com.linecorp.centraldogma.server.internal.admin.service.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresWritePermission;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@RequiresReadPermission
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class RepositoryService
extends AbstractService {
    private static final Object VOID = new Object();
    private static final Splitter termSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings();

    public RepositoryService(ProjectManager projectManager, CommandExecutor executor) {
        super(projectManager, executor);
    }

    @Get(value="/projects/{projectName}/repositories/{repoName}/revision/{revision}")
    public RevisionDto normalizeRevision(@Param String projectName, @Param String repoName, @Param String revision) {
        return DtoConverter.convert(((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).normalizeNow(new Revision(revision)));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repositories/(?<repoName>[^/]+)/files/revisions/(?<revision>[^/]+)(?<path>/.*$)")
    public CompletionStage<EntryDto> getFile(@Param String projectName, @Param String repoName, @Param String revision, @Param String path, @Param @Default(value="IDENTITY") QueryType queryType, @Param @Default(value="") String expression) {
        Query query = Query.of((QueryType)queryType, (String)path, (String[])new String[]{expression});
        Repository repo = (Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName);
        return repo.get(repo.normalizeNow(new Revision(revision)), query).thenApply(DtoConverter::convert);
    }

    @Post
    @Put
    @Path(value="/projects/{projectName}/repositories/{repoName}/files/revisions/{revision}")
    @RequiresWritePermission
    public CompletionStage<Object> addOrEditFile(@Param String projectName, @Param String repoName, @Param String revision, AggregatedHttpRequest request, ServiceRequestContext ctx) {
        Map.Entry<CommitMessageDto, Change<?>> p = RepositoryService.commitMessageAndChange(request);
        CommitMessageDto commitMessage = p.getKey();
        Change<?> change = p.getValue();
        return this.push(projectName, repoName, new Revision(revision), AuthUtil.currentAuthor(ctx), commitMessage.getSummary(), commitMessage.getDetail().getContent(), Markup.valueOf((String)commitMessage.getDetail().getMarkup()), change).thenApply(unused -> VOID);
    }

    @Post(value="regex:/projects/(?<projectName>[^/]+)/repositories/(?<repoName>[^/]+)/delete/revisions/(?<revision>[^/]+)(?<path>/.*$)")
    @RequiresWritePermission
    public HttpResponse deleteFile(@Param String projectName, @Param String repoName, @Param String revision, @Param String path, AggregatedHttpRequest request, ServiceRequestContext ctx) {
        CommitMessageDto commitMessage;
        try {
            JsonNode node = Jackson.readTree((String)request.contentUtf8());
            commitMessage = (CommitMessageDto)Jackson.convertValue((Object)node.get("commitMessage"), CommitMessageDto.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid data to be parsed", e);
        }
        CompletableFuture<?> future = this.push(projectName, repoName, new Revision(revision), AuthUtil.currentAuthor(ctx), commitMessage.getSummary(), commitMessage.getDetail().getContent(), Markup.valueOf((String)commitMessage.getDetail().getMarkup()), Change.ofRemoval((String)path));
        return HttpResponse.from((CompletionStage)future.thenApply(unused -> HttpResponse.of((HttpStatus)HttpStatus.OK)));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repositories/(?<repoName>[^/]+)/history(?<path>/.*$)")
    public CompletionStage<List<CommitDto>> getHistory(@Param String projectName, @Param String repoName, @Param String path, @Param @Default(value="-1") String from, @Param @Default(value="1") String to) {
        return ((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).history(new Revision(from), new Revision(to), path + "**").thenApply(commits -> commits.stream().map(DtoConverter::convert).collect(Collectors.toList()));
    }

    @Get(value="/projects/{projectName}/repositories/{repoName}/search/revisions/{revision}")
    public CompletionStage<List<EntryDto>> search(@Param String projectName, @Param String repoName, @Param String revision, @Param String term) {
        return ((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).find(new Revision(revision), RepositoryService.normalizeSearchTerm(term), FindOptions.FIND_ALL_WITH_CONTENT).thenApply(entries -> entries.values().stream().map(DtoConverter::convert).collect(Collectors.toList()));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repositories/(?<repoName>[^/]+)/diff(?<path>/.*$)")
    public CompletionStage<List<ChangeDto>> getDiff(@Param String projectName, @Param String repoName, @Param String path, @Param String from, @Param String to) {
        return ((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).diff(new Revision(from), new Revision(to), path).thenApply(changeMap -> changeMap.values().stream().map(DtoConverter::convert).collect(Collectors.toList()));
    }

    private CompletableFuture<?> push(String projectName, String repoName, Revision revision, Author author, String commitSummary, String commitDetail, Markup commitMarkup, Change<?> change) {
        Repository repo = (Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName);
        return this.push0(projectName, repoName, repo.normalizeNow(revision), author, commitSummary, commitDetail, commitMarkup, change);
    }

    private CompletableFuture<?> push0(String projectName, String repoName, Revision normalizedRev, Author author, String commitSummary, String commitDetail, Markup commitMarkup, Change<?> change) {
        return this.execute(Command.push(author, projectName, repoName, normalizedRev, commitSummary, commitDetail, commitMarkup, ImmutableList.of(change)));
    }

    private static Map.Entry<CommitMessageDto, Change<?>> commitMessageAndChange(AggregatedHttpRequest request) {
        try {
            Change change;
            JsonNode node = Jackson.readTree((String)request.contentUtf8());
            CommitMessageDto commitMessage = (CommitMessageDto)Jackson.convertValue((Object)node.get("commitMessage"), CommitMessageDto.class);
            EntryDto file = (EntryDto)Jackson.convertValue((Object)node.get("file"), EntryDto.class);
            switch (file.getType()) {
                case "JSON": {
                    change = Change.ofJsonUpsert((String)file.getPath(), (String)file.getContent());
                    break;
                }
                case "TEXT": {
                    change = Change.ofTextUpsert((String)file.getPath(), (String)file.getContent());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported file type: " + file.getType());
                }
            }
            return Maps.immutableEntry((Object)commitMessage, (Object)change);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid data to be parsed", e);
        }
    }

    private static String normalizeSearchTerm(String term) {
        if (Strings.isNullOrEmpty((String)term)) {
            throw new IllegalArgumentException("term should not be empty");
        }
        StringBuilder sb = new StringBuilder();
        for (String term0 : termSplitter.split((CharSequence)term)) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (term0.matches(".*[/*]+.*")) {
                sb.append(term0);
                continue;
            }
            sb.append('*').append(term0).append('*');
        }
        return sb.toString();
    }
}

