/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.ForwardingSessionManager;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;

public final class ExpiredSessionDeletingSessionManager
extends ForwardingSessionManager {
    public ExpiredSessionDeletingSessionManager(SessionManager delegate) {
        super(delegate);
    }

    @Override
    public CompletableFuture<Session> get(String sessionId) {
        return super.get(sessionId).thenApply(session -> {
            if (session != null) {
                if (Instant.now().isBefore(session.expirationTime())) {
                    return session;
                }
                this.delete(sessionId);
            }
            return null;
        });
    }
}

