/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.InetAddressPredicates;
import com.linecorp.armeria.server.ClientAddressSource;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.GracefulShutdownTimeout;
import com.linecorp.centraldogma.server.QuotaConfig;
import com.linecorp.centraldogma.server.ReplicationConfig;
import com.linecorp.centraldogma.server.TlsConfig;
import com.linecorp.centraldogma.server.auth.AuthConfig;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import io.netty.util.NetUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class CentralDogmaConfig {
    private final File dataDir;
    private final List<ServerPort> ports;
    @Nullable
    private final Integer numWorkers;
    @Nullable
    private final Integer maxNumConnections;
    @Nullable
    private final Long requestTimeoutMillis;
    @Nullable
    private final Long idleTimeoutMillis;
    @Nullable
    private final Integer maxFrameLength;
    @Nullable
    private final TlsConfig tls;
    @Nullable
    private final List<String> trustedProxyAddresses;
    @Nullable
    private final List<String> clientAddressSources;
    private final Predicate<InetAddress> trustedProxyAddressPredicate;
    private final List<ClientAddressSource> clientAddressSourceList;
    private final Integer numRepositoryWorkers;
    private final long maxRemovedRepositoryAgeMillis;
    private final String repositoryCacheSpec;
    private final boolean webAppEnabled;
    @Nullable
    private final String webAppTitle;
    private final boolean mirroringEnabled;
    private final int numMirroringThreads;
    private final int maxNumFilesPerMirror;
    private final long maxNumBytesPerMirror;
    @Nullable
    private final GracefulShutdownTimeout gracefulShutdownTimeout;
    private final ReplicationConfig replicationConfig;
    private final boolean csrfTokenRequiredForThrift;
    @Nullable
    private final String accessLogFormat;
    @Nullable
    private final AuthConfig authConfig;
    @Nullable
    private final QuotaConfig writeQuotaPerRepository;

    CentralDogmaConfig(@JsonProperty(value="dataDir", required=true) File dataDir, @JsonProperty(value="ports", required=true) @JsonDeserialize(contentUsing=ServerPortDeserializer.class) List<ServerPort> ports, @JsonProperty(value="tls") @Nullable TlsConfig tls, @JsonProperty(value="trustedProxyAddresses") @Nullable List<String> trustedProxyAddresses, @JsonProperty(value="clientAddressSources") @Nullable List<String> clientAddressSources, @JsonProperty(value="numWorkers") @Nullable Integer numWorkers, @JsonProperty(value="maxNumConnections") @Nullable Integer maxNumConnections, @JsonProperty(value="requestTimeoutMillis") @Nullable Long requestTimeoutMillis, @JsonProperty(value="idleTimeoutMillis") @Nullable Long idleTimeoutMillis, @JsonProperty(value="maxFrameLength") @Nullable Integer maxFrameLength, @JsonProperty(value="numRepositoryWorkers") @Nullable Integer numRepositoryWorkers, @JsonProperty(value="repositoryCacheSpec") @Nullable String repositoryCacheSpec, @JsonProperty(value="maxRemovedRepositoryAgeMillis") @Nullable Long maxRemovedRepositoryAgeMillis, @JsonProperty(value="gracefulShutdownTimeout") @Nullable GracefulShutdownTimeout gracefulShutdownTimeout, @JsonProperty(value="webAppEnabled") @Nullable Boolean webAppEnabled, @JsonProperty(value="webAppTitle") @Nullable String webAppTitle, @JsonProperty(value="mirroringEnabled") @Nullable Boolean mirroringEnabled, @JsonProperty(value="numMirroringThreads") @Nullable Integer numMirroringThreads, @JsonProperty(value="maxNumFilesPerMirror") @Nullable Integer maxNumFilesPerMirror, @JsonProperty(value="maxNumBytesPerMirror") @Nullable Long maxNumBytesPerMirror, @JsonProperty(value="replication") @Nullable ReplicationConfig replicationConfig, @JsonProperty(value="csrfTokenRequiredForThrift") @Nullable Boolean csrfTokenRequiredForThrift, @JsonProperty(value="accessLogFormat") @Nullable String accessLogFormat, @JsonProperty(value="authentication") @Nullable AuthConfig authConfig, @JsonProperty(value="writeQuotaPerRepository") @Nullable QuotaConfig writeQuotaPerRepository) {
        this.dataDir = Objects.requireNonNull(dataDir, "dataDir");
        this.ports = ImmutableList.copyOf((Collection)Objects.requireNonNull(ports, "ports"));
        Preconditions.checkArgument((!ports.isEmpty() ? 1 : 0) != 0, (Object)"ports must have at least one port.");
        this.tls = tls;
        this.trustedProxyAddresses = trustedProxyAddresses;
        this.clientAddressSources = clientAddressSources;
        this.numWorkers = numWorkers;
        this.maxNumConnections = maxNumConnections;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.maxFrameLength = maxFrameLength;
        this.numRepositoryWorkers = (Integer)MoreObjects.firstNonNull((Object)numRepositoryWorkers, (Object)16);
        Preconditions.checkArgument((this.numRepositoryWorkers > 0 ? 1 : 0) != 0, (String)"numRepositoryWorkers: %s (expected: > 0)", (Object)this.numRepositoryWorkers);
        this.maxRemovedRepositoryAgeMillis = (Long)MoreObjects.firstNonNull((Object)maxRemovedRepositoryAgeMillis, (Object)604800000L);
        Preconditions.checkArgument((this.maxRemovedRepositoryAgeMillis >= 0L ? 1 : 0) != 0, (String)"maxRemovedRepositoryAgeMillis: %s (expected: >= 0)", (long)this.maxRemovedRepositoryAgeMillis);
        this.repositoryCacheSpec = RepositoryCache.validateCacheSpec((String)MoreObjects.firstNonNull((Object)repositoryCacheSpec, (Object)"maximumWeight=134217728,expireAfterAccess=5m"));
        this.webAppEnabled = (Boolean)MoreObjects.firstNonNull((Object)webAppEnabled, (Object)true);
        this.webAppTitle = webAppTitle;
        this.mirroringEnabled = (Boolean)MoreObjects.firstNonNull((Object)mirroringEnabled, (Object)true);
        this.numMirroringThreads = (Integer)MoreObjects.firstNonNull((Object)numMirroringThreads, (Object)16);
        Preconditions.checkArgument((this.numMirroringThreads > 0 ? 1 : 0) != 0, (String)"numMirroringThreads: %s (expected: > 0)", (int)this.numMirroringThreads);
        this.maxNumFilesPerMirror = (Integer)MoreObjects.firstNonNull((Object)maxNumFilesPerMirror, (Object)8192);
        Preconditions.checkArgument((this.maxNumFilesPerMirror > 0 ? 1 : 0) != 0, (String)"maxNumFilesPerMirror: %s (expected: > 0)", (int)this.maxNumFilesPerMirror);
        this.maxNumBytesPerMirror = (Long)MoreObjects.firstNonNull((Object)maxNumBytesPerMirror, (Object)0x2000000L);
        Preconditions.checkArgument((this.maxNumBytesPerMirror > 0L ? 1 : 0) != 0, (String)"maxNumBytesPerMirror: %s (expected: > 0)", (long)this.maxNumBytesPerMirror);
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
        this.replicationConfig = (ReplicationConfig)MoreObjects.firstNonNull((Object)replicationConfig, (Object)ReplicationConfig.NONE);
        this.csrfTokenRequiredForThrift = (Boolean)MoreObjects.firstNonNull((Object)csrfTokenRequiredForThrift, (Object)true);
        this.accessLogFormat = accessLogFormat;
        this.authConfig = authConfig;
        boolean hasTrustedProxyAddrCfg = trustedProxyAddresses != null && !trustedProxyAddresses.isEmpty();
        this.trustedProxyAddressPredicate = hasTrustedProxyAddrCfg ? CentralDogmaConfig.toTrustedProxyAddressPredicate(trustedProxyAddresses) : addr -> false;
        this.clientAddressSourceList = CentralDogmaConfig.toClientAddressSourceList(clientAddressSources, hasTrustedProxyAddrCfg, ports.stream().anyMatch(ServerPort::hasProxyProtocol));
        this.writeQuotaPerRepository = writeQuotaPerRepository;
    }

    @JsonProperty
    public File dataDir() {
        return this.dataDir;
    }

    @JsonProperty
    @JsonSerialize(contentUsing=ServerPortSerializer.class)
    public List<ServerPort> ports() {
        return this.ports;
    }

    @Nullable
    @JsonProperty
    public TlsConfig tls() {
        return this.tls;
    }

    @Nullable
    @JsonProperty
    public List<String> trustedProxyAddresses() {
        return this.trustedProxyAddresses;
    }

    @Nullable
    @JsonProperty
    public List<String> clientAddressSources() {
        return this.clientAddressSources;
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    public Optional<Integer> numWorkers() {
        return Optional.ofNullable(this.numWorkers);
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    public Optional<Integer> maxNumConnections() {
        return Optional.ofNullable(this.maxNumConnections);
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    public Optional<Long> requestTimeoutMillis() {
        return Optional.ofNullable(this.requestTimeoutMillis);
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    public Optional<Long> idleTimeoutMillis() {
        return Optional.ofNullable(this.idleTimeoutMillis);
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    public Optional<Integer> maxFrameLength() {
        return Optional.ofNullable(this.maxFrameLength);
    }

    @JsonProperty
    int numRepositoryWorkers() {
        return this.numRepositoryWorkers;
    }

    @JsonProperty
    public long maxRemovedRepositoryAgeMillis() {
        return this.maxRemovedRepositoryAgeMillis;
    }

    @JsonProperty
    @Deprecated
    public String cacheSpec() {
        return this.repositoryCacheSpec;
    }

    @JsonProperty
    public String repositoryCacheSpec() {
        return this.repositoryCacheSpec;
    }

    @JsonProperty
    @JsonSerialize(converter=OptionalConverter.class)
    public Optional<GracefulShutdownTimeout> gracefulShutdownTimeout() {
        return Optional.ofNullable(this.gracefulShutdownTimeout);
    }

    @JsonProperty
    public boolean isWebAppEnabled() {
        return this.webAppEnabled;
    }

    @Nullable
    @JsonProperty(value="webAppTitle")
    public String webAppTitle() {
        return this.webAppTitle;
    }

    @JsonProperty
    public boolean isMirroringEnabled() {
        return this.mirroringEnabled;
    }

    @JsonProperty
    public int numMirroringThreads() {
        return this.numMirroringThreads;
    }

    @JsonProperty
    public int maxNumFilesPerMirror() {
        return this.maxNumFilesPerMirror;
    }

    @JsonProperty
    public long maxNumBytesPerMirror() {
        return this.maxNumBytesPerMirror;
    }

    @JsonProperty(value="replication")
    public ReplicationConfig replicationConfig() {
        return this.replicationConfig;
    }

    @JsonProperty
    public boolean isCsrfTokenRequiredForThrift() {
        return this.csrfTokenRequiredForThrift;
    }

    @JsonProperty
    @Nullable
    public String accessLogFormat() {
        return this.accessLogFormat;
    }

    @Nullable
    @JsonProperty(value="authentication")
    public AuthConfig authConfig() {
        return this.authConfig;
    }

    @Nullable
    @JsonProperty(value="writeQuotaPerRepository")
    public QuotaConfig writeQuotaPerRepository() {
        return this.writeQuotaPerRepository;
    }

    public String toString() {
        try {
            return Jackson.writeValueAsPrettyString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    Predicate<InetAddress> trustedProxyAddressPredicate() {
        return this.trustedProxyAddressPredicate;
    }

    List<ClientAddressSource> clientAddressSourceList() {
        return this.clientAddressSourceList;
    }

    private static Predicate<InetAddress> toTrustedProxyAddressPredicate(List<String> trustedProxyAddresses) {
        String first = trustedProxyAddresses.get(0);
        Predicate predicate = first.indexOf(47) < 0 ? InetAddressPredicates.ofExact((String)first) : InetAddressPredicates.ofCidr((String)first);
        for (int i = 1; i < trustedProxyAddresses.size(); ++i) {
            String next = trustedProxyAddresses.get(i);
            predicate = predicate.or(next.indexOf(47) < 0 ? InetAddressPredicates.ofExact((String)next) : InetAddressPredicates.ofCidr((String)next));
        }
        return predicate;
    }

    private static List<ClientAddressSource> toClientAddressSourceList(@Nullable List<String> clientAddressSources, boolean useDefaultSources, boolean specifiedProxyProtocol) {
        if (clientAddressSources != null && !clientAddressSources.isEmpty()) {
            return (List)clientAddressSources.stream().map(name -> "PROXY_PROTOCOL".equals(name) ? ClientAddressSource.ofProxyProtocol() : ClientAddressSource.ofHeader((CharSequence)name)).collect(ImmutableList.toImmutableList());
        }
        if (useDefaultSources) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            builder.add((Object)ClientAddressSource.ofHeader((CharSequence)HttpHeaderNames.FORWARDED));
            builder.add((Object)ClientAddressSource.ofHeader((CharSequence)HttpHeaderNames.X_FORWARDED_FOR));
            if (specifiedProxyProtocol) {
                builder.add((Object)ClientAddressSource.ofProxyProtocol());
            }
            return builder.build();
        }
        return ImmutableList.of();
    }

    static final class OptionalConverter
    extends StdConverter<Optional<?>, Object> {
        OptionalConverter() {
        }

        @Nullable
        public Object convert(Optional<?> value) {
            return value.orElse(null);
        }
    }

    static final class ServerPortDeserializer
    extends JsonDeserializer<ServerPort> {
        ServerPortDeserializer() {
        }

        public ServerPort deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            JsonNode root = (JsonNode)p.getCodec().readTree(p);
            JsonNode localAddress = root.get("localAddress");
            if (localAddress == null || localAddress.getNodeType() != JsonNodeType.OBJECT) {
                return ServerPortDeserializer.fail(ctx, root);
            }
            JsonNode host = localAddress.get("host");
            if (host == null || host.getNodeType() != JsonNodeType.STRING) {
                return ServerPortDeserializer.fail(ctx, root);
            }
            JsonNode port = localAddress.get("port");
            if (port == null || port.getNodeType() != JsonNodeType.NUMBER) {
                return ServerPortDeserializer.fail(ctx, root);
            }
            ImmutableSet.Builder protocolsBuilder = ImmutableSet.builder();
            JsonNode protocols = root.get("protocols");
            if (protocols != null) {
                if (protocols.getNodeType() != JsonNodeType.ARRAY) {
                    return ServerPortDeserializer.fail(ctx, root);
                }
                protocols.elements().forEachRemaining(protocol -> protocolsBuilder.add((Object)SessionProtocol.of((String)protocol.textValue())));
            } else {
                JsonNode protocol2 = root.get("protocol");
                if (protocol2 == null || protocol2.getNodeType() != JsonNodeType.STRING) {
                    return ServerPortDeserializer.fail(ctx, root);
                }
                protocolsBuilder.add((Object)SessionProtocol.of((String)protocol2.textValue()));
            }
            String hostVal = host.textValue();
            int portVal = port.intValue();
            InetSocketAddress localAddressVal = "*".equals(hostVal) ? new InetSocketAddress(portVal) : new InetSocketAddress(hostVal, portVal);
            return new ServerPort(localAddressVal, (Iterable)protocolsBuilder.build());
        }

        private static ServerPort fail(DeserializationContext ctx, JsonNode root) throws JsonMappingException {
            ctx.reportInputMismatch(ServerPort.class, "invalid server port information: %s", new Object[]{root});
            throw new Error();
        }
    }

    static final class ServerPortSerializer
    extends JsonSerializer<ServerPort> {
        ServerPortSerializer() {
        }

        public void serialize(ServerPort value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String hs;
            InetSocketAddress localAddr = value.localAddress();
            int port = localAddr.getPort();
            String host = localAddr.getAddress().isAnyLocalAddress() ? "*" : (NetUtil.isValidIpV6Address((String)(hs = localAddr.getHostString())) ? NetUtil.toAddressString((InetAddress)localAddr.getAddress()) : hs);
            gen.writeStartObject();
            gen.writeObjectFieldStart("localAddress");
            gen.writeStringField("host", host);
            gen.writeNumberField("port", port);
            gen.writeEndObject();
            gen.writeArrayFieldStart("protocols");
            for (SessionProtocol protocol : value.protocols()) {
                gen.writeString(protocol.uriText());
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }
}

