/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.CacheableCall;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class CacheableFindLatestRevCall
extends CacheableCall<Revision> {
    static final Revision EMPTY = new Revision(Integer.MIN_VALUE);
    final Revision lastKnownRevision;
    final Revision headRevision;
    final String pathPattern;
    private final int hashCode;

    CacheableFindLatestRevCall(Repository repo, Revision lastKnownRevision, Revision headRevision, String pathPattern) {
        super(repo);
        this.lastKnownRevision = Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        this.headRevision = Objects.requireNonNull(headRevision, "headRevision");
        this.pathPattern = Objects.requireNonNull(pathPattern, "pathPattern");
        this.hashCode = pathPattern.hashCode() * 31 + System.identityHashCode(repo);
        assert (!lastKnownRevision.isRelative());
    }

    @Override
    protected int weigh(Revision value) {
        return this.pathPattern.length();
    }

    @Override
    public CompletableFuture<Revision> execute() {
        return this.repo().findLatestRevision(this.lastKnownRevision, this.pathPattern).thenApply(e -> (Revision)MoreObjects.firstNonNull((Object)e, (Object)EMPTY));
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableFindLatestRevCall that = (CacheableFindLatestRevCall)o;
        return this.lastKnownRevision.equals((Object)that.lastKnownRevision) && this.headRevision.equals((Object)that.headRevision) && this.pathPattern.equals(that.pathPattern);
    }

    @Override
    protected void toString(MoreObjects.ToStringHelper helper) {
        helper.add("lastKnownRevision", (Object)this.lastKnownRevision).add("headRevision", (Object)this.headRevision).add("pathPattern", (Object)this.pathPattern);
    }
}

