/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.api.v1.CreateRepositoryRequest;
import com.linecorp.centraldogma.internal.api.v1.RepositoryDto;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRole;
import com.linecorp.centraldogma.server.internal.api.converter.CreateApiResponseConverter;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.ProjectRole;
import com.linecorp.centraldogma.server.metadata.User;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

@ProducesJson
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class RepositoryServiceV1
extends AbstractService {
    private final MetadataService mds;

    public RepositoryServiceV1(ProjectManager projectManager, CommandExecutor executor, MetadataService mds) {
        super(projectManager, executor);
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    @Get(value="/projects/{projectName}/repos")
    public CompletableFuture<List<RepositoryDto>> listRepositories(ServiceRequestContext ctx, Project project, @Param @Nullable String status, User user) {
        if (status != null) {
            HttpApiUtil.checkStatusArgument(status);
        }
        return this.mds.findRole(project.name(), user).handle((role, throwable) -> {
            boolean hasOwnerRole;
            boolean bl = hasOwnerRole = role == ProjectRole.OWNER;
            if (status != null) {
                if (hasOwnerRole) {
                    return (List)project.repos().listRemoved().keySet().stream().map(RepositoryDto::new).collect(ImmutableList.toImmutableList());
                }
                return (List)HttpApiUtil.throwResponse((RequestContext)ctx, HttpStatus.FORBIDDEN, "You must be an owner of project '%s' to retrieve removed repositories.", project.name());
            }
            return (List)project.repos().list().values().stream().filter(r -> user.isAdmin() || !"dogma".equals(r.name())).filter(r -> hasOwnerRole || !"meta".equals(r.name())).map(DtoConverter::convert).collect(ImmutableList.toImmutableList());
        });
    }

    @Post(value="/projects/{projectName}/repos")
    @StatusCode(value=201)
    @ResponseConverter(value=CreateApiResponseConverter.class)
    @RequiresRole(roles={ProjectRole.OWNER})
    public CompletableFuture<RepositoryDto> createRepository(ServiceRequestContext ctx, Project project, CreateRepositoryRequest request, Author author) {
        if (Project.isReservedRepoName(request.name())) {
            return (CompletableFuture)HttpApiUtil.throwResponse((RequestContext)ctx, HttpStatus.FORBIDDEN, "A reserved repository cannot be created.");
        }
        return ((CompletableFuture)this.execute(Command.createRepository(author, project.name(), request.name())).thenCompose(unused -> this.mds.addRepo(author, project.name(), request.name()))).handle(HttpApiUtil.returnOrThrow(() -> DtoConverter.convert((Repository)project.repos().get(request.name()))));
    }

    @Delete(value="/projects/{projectName}/repos/{repoName}")
    @RequiresRole(roles={ProjectRole.OWNER})
    public CompletableFuture<Void> removeRepository(ServiceRequestContext ctx, @Param String repoName, Repository repository, Author author) {
        if (Project.isReservedRepoName(repoName)) {
            return (CompletableFuture)HttpApiUtil.throwResponse((RequestContext)ctx, HttpStatus.FORBIDDEN, "A reserved repository cannot be removed.");
        }
        return ((CompletableFuture)this.execute(Command.removeRepository(author, repository.parent().name(), repository.name())).thenCompose(unused -> this.mds.removeRepo(author, repository.parent().name(), repository.name()))).handle(HttpApiUtil::throwUnsafelyIfNonNull);
    }

    @Delete(value="/projects/{projectName}/repos/{repoName}/removed")
    @RequiresRole(roles={ProjectRole.OWNER})
    public CompletableFuture<Void> purgeRepository(@Param String repoName, Project project, Author author) {
        return this.execute(Command.purgeRepository(author, project.name(), repoName)).thenCompose(unused -> this.mds.purgeRepo(author, project.name(), repoName).handle(HttpApiUtil::throwUnsafelyIfNonNull));
    }

    @Consumes(value="application/json-patch+json")
    @Patch(value="/projects/{projectName}/repos/{repoName}")
    @RequiresRole(roles={ProjectRole.OWNER})
    public CompletableFuture<RepositoryDto> patchRepository(@Param String repoName, Project project, JsonNode node, Author author) {
        HttpApiUtil.checkUnremoveArgument(node);
        return ((CompletableFuture)this.execute(Command.unremoveRepository(author, project.name(), repoName)).thenCompose(unused -> this.mds.restoreRepo(author, project.name(), repoName))).handle(HttpApiUtil.returnOrThrow(() -> DtoConverter.convert((Repository)project.repos().get(repoName))));
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/revision/{revision}")
    @RequiresReadPermission
    public Map<String, Integer> normalizeRevision(Repository repository, @Param String revision) {
        Revision normalizedRevision = repository.normalizeNow(new Revision(revision));
        return ImmutableMap.of((Object)"revision", (Object)normalizedRevision.major());
    }
}

