/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ZooKeeperServerConfig {
    private final String host;
    private final int quorumPort;
    private final int electionPort;
    private final int clientPort;
    @Nullable
    private final Integer groupId;
    private final int weight;

    @JsonCreator
    public ZooKeeperServerConfig(@JsonProperty(value="host", required=true) String host, @JsonProperty(value="quorumPort", required=true) int quorumPort, @JsonProperty(value="electionPort", required=true) int electionPort, @JsonProperty(value="clientPort", defaultValue="0") @Nullable Integer clientPort, @JsonProperty(value="groupId") @Nullable Integer groupId, @JsonProperty(value="weight", defaultValue="1") @Nullable Integer weight) {
        this.host = Objects.requireNonNull(host, "host");
        this.quorumPort = ZooKeeperServerConfig.validatePort(quorumPort, "quorumPort");
        this.electionPort = ZooKeeperServerConfig.validatePort(electionPort, "electionPort");
        if (clientPort == null) {
            clientPort = 0;
        }
        Preconditions.checkArgument((clientPort >= 0 && clientPort <= 65535 ? 1 : 0) != 0, (String)"clientPort: %s (expected: 0-65535)", (Object)clientPort);
        this.clientPort = clientPort;
        this.groupId = groupId;
        if (weight == null) {
            weight = 1;
        }
        Preconditions.checkArgument((weight >= 0 ? 1 : 0) != 0, (String)"weight: %s (expected: >= 0)", (Object)weight);
        this.weight = weight;
    }

    private static int validatePort(int port, String name) {
        Preconditions.checkArgument((port > 0 && port <= 65535 ? 1 : 0) != 0, (String)"%s: %s (expected: 1-65535)", (Object)name, (int)port);
        return port;
    }

    @JsonProperty
    public String host() {
        return this.host;
    }

    @JsonProperty
    public int quorumPort() {
        return this.quorumPort;
    }

    @JsonProperty
    public int electionPort() {
        return this.electionPort;
    }

    @JsonProperty
    public int clientPort() {
        return this.clientPort;
    }

    @Nullable
    @JsonProperty
    public Integer groupId() {
        return this.groupId;
    }

    @JsonProperty
    public int weight() {
        return this.weight;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.quorumPort, this.electionPort, this.clientPort, this.groupId, this.weight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZooKeeperServerConfig that = (ZooKeeperServerConfig)o;
        return this.host.equals(that.host) && this.quorumPort == that.quorumPort && this.electionPort == that.electionPort && this.clientPort == that.clientPort && Objects.equals(this.groupId, that.groupId) && this.weight == that.weight;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.host).add("quorumPort", this.quorumPort).add("electionPort", this.electionPort).add("clientPort", this.clientPort).add("groupId", (Object)this.groupId).add("weight", this.weight).toString();
    }
}

