/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.mirror.credential.AbstractMirrorCredential;
import com.linecorp.centraldogma.server.internal.mirror.credential.MirrorCredentialUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class PasswordMirrorCredential
extends AbstractMirrorCredential {
    private final String username;
    private final String password;

    @JsonCreator
    public PasswordMirrorCredential(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="hostnamePatterns") @Nullable @JsonDeserialize(contentAs=Pattern.class) Iterable<Pattern> hostnamePatterns, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password) {
        super(id, hostnamePatterns);
        this.username = MirrorCredentialUtil.requireNonEmpty(username, "username");
        this.password = Objects.requireNonNull(password, "password");
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PasswordMirrorCredential)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PasswordMirrorCredential that = (PasswordMirrorCredential)o;
        return this.username.equals(that.username) && this.password.equals(that.password);
    }

    @Override
    void addProperties(MoreObjects.ToStringHelper helper) {
        helper.add("username", (Object)this.username);
    }
}

