/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class SessionTokenAuthorizer
implements Authorizer<HttpRequest> {
    private final SessionManager sessionManager;
    private final Set<String> administrators;

    public SessionTokenAuthorizer(SessionManager sessionManager, Set<String> administrators) {
        this.sessionManager = Objects.requireNonNull(sessionManager, "sessionManager");
        this.administrators = Objects.requireNonNull(administrators, "administrators");
    }

    public CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest data) {
        OAuth2Token token = (OAuth2Token)AuthTokenExtractors.oAuth2().apply(data.headers());
        if (token == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.sessionManager.get(token.accessToken()).thenApply(session -> {
            if (session == null) {
                return false;
            }
            String username = session.username();
            List<String> roles = this.administrators.contains(username) ? User.LEVEL_ADMIN : User.LEVEL_USER;
            User user = new User(username, roles);
            AuthUtil.setCurrentUser(ctx, user);
            return true;
        });
    }
}

