/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.thrift;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenlessClientLogger
extends SimpleDecoratingHttpService {
    private static final Logger logger = LoggerFactory.getLogger(TokenlessClientLogger.class);
    private static final Pattern PATTERN = Pattern.compile("\\s*[Bb][Ee][Aa][Rr][Ee][Rr]\\s+anonymous\\s*");
    private final Clock clock;
    private final ConcurrentMap<String, Instant> reportedAddresses = new ConcurrentHashMap<String, Instant>();

    public TokenlessClientLogger(HttpService delegate) {
        this(delegate, Clock.systemUTC());
    }

    @VisibleForTesting
    TokenlessClientLogger(HttpService delegate, Clock clock) {
        super(delegate);
        this.clock = Objects.requireNonNull(clock, "clock");
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Instant now;
        InetSocketAddress raddr;
        String ip;
        Instant lastReport;
        boolean report;
        String authorization = req.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if ((authorization == null || !PATTERN.matcher(authorization).matches()) && (report = (lastReport = this.reportedAddresses.putIfAbsent(ip = (raddr = (InetSocketAddress)ctx.remoteAddress()).getAddress().getHostAddress(), now = Instant.now(this.clock))) == null ? true : (ChronoUnit.DAYS.between(lastReport, now) >= 1L ? this.reportedAddresses.replace(ip, lastReport, now) : false))) {
            this.report(raddr.getHostString(), ip);
        }
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
    }

    @VisibleForTesting
    void report(String hostname, String ip) {
        logger.debug("Received a request without 'authorization' header from: {}/{}", (Object)hostname, (Object)ip);
    }
}

