/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.server.metadata.User;
import io.netty.util.AttributeKey;
import java.util.Objects;

public final class AuthUtil {
    @VisibleForTesting
    public static final AttributeKey<User> CURRENT_USER_KEY = AttributeKey.valueOf(AuthUtil.class, (String)"CURRENT_USER");

    public static Author currentAuthor(ServiceRequestContext ctx) {
        User user = (User)ctx.attr(CURRENT_USER_KEY);
        assert (user != null);
        return user == User.DEFAULT ? Author.DEFAULT : new Author(user.name(), user.email());
    }

    public static Author currentAuthor() {
        return AuthUtil.currentAuthor((ServiceRequestContext)RequestContext.current());
    }

    public static User currentUser(ServiceRequestContext ctx) {
        return (User)ctx.attr(CURRENT_USER_KEY);
    }

    public static User currentUser() {
        return AuthUtil.currentUser((ServiceRequestContext)RequestContext.current());
    }

    public static void setCurrentUser(ServiceRequestContext ctx, User currentUser) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(currentUser, "currentUser");
        ctx.setAttr(CURRENT_USER_KEY, (Object)currentUser);
    }

    private AuthUtil() {
    }
}

