/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.storage.DirectoryBasedStorageManager;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepositoryFormat;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import com.linecorp.centraldogma.server.storage.repository.RepositoryManager;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRepositoryManager
extends DirectoryBasedStorageManager<Repository>
implements RepositoryManager {
    private static final Logger logger = LoggerFactory.getLogger(GitRepositoryManager.class);
    private final Project parent;
    private final GitRepositoryFormat preferredFormat;
    private final Executor repositoryWorker;
    private final RepositoryCache cache;

    public GitRepositoryManager(Project parent, File rootDir, Executor repositoryWorker, Executor purgeWorker, @Nullable RepositoryCache cache) {
        this(parent, rootDir, GitRepositoryFormat.V1, repositoryWorker, purgeWorker, cache);
    }

    public GitRepositoryManager(Project parent, File rootDir, GitRepositoryFormat preferredFormat, Executor repositoryWorker, Executor purgeWorker, @Nullable RepositoryCache cache) {
        super(rootDir, Repository.class, purgeWorker);
        this.parent = Objects.requireNonNull(parent, "parent");
        this.preferredFormat = Objects.requireNonNull(preferredFormat, "preferredFormat");
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.cache = cache;
        this.init();
    }

    @Override
    public Project parent() {
        return this.parent;
    }

    @Override
    protected Repository openChild(File childDir) throws Exception {
        GitRepository repository = new GitRepository(this.parent, childDir, this.repositoryWorker, this.cache);
        if (repository.needsMigration(this.preferredFormat)) {
            return GitRepositoryManager.migrate(childDir, this.parent, this.repositoryWorker, repository, this.preferredFormat, this.cache);
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Repository migrate(File childDir, Project project, Executor repositoryWorker, GitRepository oldRepo, GitRepositoryFormat newFormat, RepositoryCache cache) throws IOException {
        boolean closedOldRepo = false;
        try {
            logger.info("Migrating from {} to {}: {}", new Object[]{oldRepo.format(), newFormat, oldRepo});
            File newChildDir = new File(childDir.getParentFile(), "_newfmt_" + childDir.getName());
            File oldChildDir = new File(childDir.getParentFile(), "_oldfmt_" + childDir.getName());
            if (newChildDir.exists()) {
                GitRepositoryManager.deleteCruft(newChildDir);
            }
            if (oldChildDir.exists()) {
                GitRepositoryManager.deleteCruft(oldChildDir);
            }
            oldRepo.cloneTo(newChildDir, newFormat, new MigrationProgressLogger(oldRepo));
            oldRepo.internalClose();
            closedOldRepo = true;
            if (!childDir.renameTo(oldChildDir)) {
                throw new IOException("failed to rename " + childDir + " to " + oldChildDir);
            }
            if (!newChildDir.renameTo(childDir)) {
                throw new IOException("failed to rename " + newChildDir + " to " + childDir);
            }
            GitRepository newRepo = new GitRepository(project, childDir, repositoryWorker, cache);
            logger.info("Migrated from {} to {}: {}", new Object[]{oldRepo.format(), newFormat, newRepo});
            GitRepository gitRepository = newRepo;
            return gitRepository;
        }
        finally {
            if (!closedOldRepo) {
                oldRepo.internalClose();
            }
        }
    }

    private static void deleteCruft(File dir) throws IOException {
        logger.info("Deleting the cruft from previous migration: {}", (Object)dir);
        Util.deleteFileTree((File)dir);
        logger.info("Deleted the cruft from previous migration: {}", (Object)dir);
    }

    @Override
    protected Repository createChild(File childDir, Author author, long creationTimeMillis) throws Exception {
        return new GitRepository(this.parent, childDir, this.preferredFormat, this.repositoryWorker, creationTimeMillis, author, this.cache);
    }

    @Override
    protected void closeChild(File childDir, Repository child, Supplier<CentralDogmaException> failureCauseSupplier) {
        ((GitRepository)child).close(failureCauseSupplier);
    }

    @Override
    protected CentralDogmaException newStorageExistsException(String name) {
        return new RepositoryExistsException(this.parent().name() + '/' + name);
    }

    @Override
    protected CentralDogmaException newStorageNotFoundException(String name) {
        return new RepositoryNotFoundException(this.parent().name() + '/' + name);
    }

    private static class MigrationProgressLogger
    implements BiConsumer<Integer, Integer> {
        private static final long REPORT_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(10L);
        private final String name;
        private final long startTimeNanos;
        private long lastReportTimeNanos;

        MigrationProgressLogger(Repository repo) {
            this.name = repo.parent().name() + '/' + repo.name();
            this.startTimeNanos = this.lastReportTimeNanos = System.nanoTime();
        }

        @Override
        public void accept(Integer current, Integer total) {
            long currentTimeNanos = System.nanoTime();
            long elapsedTimeNanos = currentTimeNanos - this.startTimeNanos;
            if (currentTimeNanos - this.lastReportTimeNanos > REPORT_INTERVAL_NANOS) {
                logger.info("{}: {}% ({}/{}) - took {}", new Object[]{this.name, (int)((double)current.intValue() / (double)total.intValue() * 100.0), current, total, TextFormatter.elapsed((long)elapsedTimeNanos)});
                this.lastReportTimeNanos = currentTimeNanos;
            } else if (current.equals(total)) {
                logger.info("{}: 100% ({}/{}) - took {}", new Object[]{this.name, current, total, TextFormatter.elapsed((long)elapsedTimeNanos)});
            }
        }
    }
}

