/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.api.v1.CreateProjectRequest;
import com.linecorp.centraldogma.internal.api.v1.ProjectDto;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresAdministrator;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRole;
import com.linecorp.centraldogma.server.internal.api.converter.CreateApiResponseConverter;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.ProjectRole;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@ProducesJson
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class ProjectServiceV1
extends AbstractService {
    private final MetadataService mds;

    public ProjectServiceV1(ProjectManager projectManager, CommandExecutor executor, MetadataService mds) {
        super(projectManager, executor);
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    @Get(value="/projects")
    public CompletableFuture<List<ProjectDto>> listProjects(@Param(value="status") Optional<String> status) {
        if (status.isPresent()) {
            HttpApiUtil.checkStatusArgument(status.get());
            return CompletableFuture.supplyAsync(() -> (List)this.projectManager().listRemoved().keySet().stream().map(ProjectDto::new).collect(ImmutableList.toImmutableList()));
        }
        return CompletableFuture.supplyAsync(() -> (List)this.projectManager().list().values().stream().map(DtoConverter::convert).collect(ImmutableList.toImmutableList()));
    }

    @Post(value="/projects")
    @StatusCode(value=201)
    @ResponseConverter(value=CreateApiResponseConverter.class)
    public CompletableFuture<ProjectDto> createProject(CreateProjectRequest request, Author author) {
        return this.execute(Command.createProject(author, request.name())).handle(HttpApiUtil.returnOrThrow(() -> DtoConverter.convert((Project)this.projectManager().get(request.name()))));
    }

    @Get(value="/projects/{projectName}")
    @RequiresRole(roles={ProjectRole.OWNER, ProjectRole.MEMBER})
    public CompletableFuture<ProjectMetadata> getProjectMetadata(@Param(value="projectName") String projectName, @Param(value="checkPermissionOnly") Optional<Boolean> isCheckPermissionOnly) {
        if (isCheckPermissionOnly.orElse(false).booleanValue()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.mds.getProject(projectName);
    }

    @Delete(value="/projects/{projectName}")
    @RequiresRole(roles={ProjectRole.OWNER})
    public CompletableFuture<Void> removeProject(Project project, Author author) {
        return ((CompletableFuture)this.mds.removeProject(author, project.name()).thenCompose(unused -> this.execute(Command.removeProject(author, project.name())))).handle(HttpApiUtil::throwUnsafelyIfNonNull);
    }

    @Delete(value="/projects/{projectName}/removed")
    @RequiresRole(roles={ProjectRole.OWNER})
    public CompletableFuture<Void> purgeProject(@Param(value="projectName") String projectName, Author author) {
        return this.execute(Command.purgeProject(author, projectName)).handle(HttpApiUtil::throwUnsafelyIfNonNull);
    }

    @Consumes(value="application/json-patch+json")
    @Patch(value="/projects/{projectName}")
    @RequiresAdministrator
    public CompletableFuture<ProjectDto> patchProject(@Param(value="projectName") String projectName, JsonNode node, Author author) {
        HttpApiUtil.checkUnremoveArgument(node);
        return ((CompletableFuture)this.execute(Command.unremoveProject(author, projectName)).thenCompose(unused -> this.mds.restoreProject(author, projectName))).handle(HttpApiUtil.returnOrThrow(() -> DtoConverter.convert((Project)this.projectManager().get(projectName))));
    }
}

