/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.auth.AuthConfig;
import com.linecorp.centraldogma.server.auth.Session;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public final class AuthProviderParameters {
    private final Authorizer<HttpRequest> authorizer;
    private final CentralDogmaConfig config;
    private final AuthConfig authConfig;
    private final Supplier<String> sessionIdGenerator;
    private final Function<Session, CompletableFuture<Void>> loginSessionPropagator;
    private final Function<String, CompletableFuture<Void>> logoutSessionPropagator;

    public AuthProviderParameters(Authorizer<HttpRequest> authorizer, CentralDogmaConfig config, Supplier<String> sessionIdGenerator, Function<Session, CompletableFuture<Void>> loginSessionPropagator, Function<String, CompletableFuture<Void>> logoutSessionPropagator) {
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer");
        this.config = Objects.requireNonNull(config, "config");
        this.sessionIdGenerator = Objects.requireNonNull(sessionIdGenerator, "sessionIdGenerator");
        this.loginSessionPropagator = Objects.requireNonNull(loginSessionPropagator, "loginSessionPropagator");
        this.logoutSessionPropagator = Objects.requireNonNull(logoutSessionPropagator, "logoutSessionPropagator");
        this.authConfig = Objects.requireNonNull(config.authConfig(), "authConfig");
    }

    public Authorizer<HttpRequest> authorizer() {
        return this.authorizer;
    }

    public CentralDogmaConfig config() {
        return this.config;
    }

    public AuthConfig authConfig() {
        return this.authConfig;
    }

    public Supplier<String> sessionIdGenerator() {
        return this.sessionIdGenerator;
    }

    public Function<Session, CompletableFuture<Void>> loginSessionPropagator() {
        return this.loginSessionPropagator;
    }

    public Function<String, CompletableFuture<Void>> logoutSessionPropagator() {
        return this.logoutSessionPropagator;
    }
}

