/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.thrift;

import com.linecorp.armeria.common.DefaultRpcResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.server.RpcService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingRpcService;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaException;
import com.linecorp.centraldogma.server.internal.thrift.CentralDogmaExceptions;
import com.linecorp.centraldogma.server.internal.thrift.Converter;

public final class CentralDogmaExceptionTranslator
extends SimpleDecoratingRpcService {
    public CentralDogmaExceptionTranslator(RpcService delegate) {
        super(delegate);
    }

    public RpcResponse serve(ServiceRequestContext ctx, RpcRequest req) throws Exception {
        DefaultRpcResponse newRes = new DefaultRpcResponse();
        try {
            RpcResponse oldRes = (RpcResponse)((Service)this.delegate()).serve(ctx, (Request)req);
            oldRes.handle((res, cause) -> {
                if (cause != null) {
                    CentralDogmaExceptionTranslator.handleException(req, newRes, cause);
                } else {
                    newRes.complete(res);
                }
                return null;
            });
        }
        catch (Throwable cause2) {
            CentralDogmaExceptionTranslator.handleException(req, newRes, cause2);
        }
        return newRes;
    }

    private static void handleException(RpcRequest req, DefaultRpcResponse res, Throwable cause) {
        CentralDogmaException convertedCause = Converter.convert(cause);
        CentralDogmaExceptions.log(req.method(), convertedCause);
        res.completeExceptionally((Throwable)convertedCause);
    }
}

