/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.JacksonRequestConverterFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;

public final class CommitMessageRequestConverter
implements RequestConverterFunction {
    private final JacksonRequestConverterFunction delegate = new JacksonRequestConverterFunction();

    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType) throws Exception {
        if (expectedResultType == CommitMessageDto.class) {
            JsonNode node = (JsonNode)this.delegate.convertRequest(ctx, request, JsonNode.class);
            if (node == null || node.get("commitMessage") == null) {
                throw new IllegalArgumentException("commitMessage should be non-null.");
            }
            return CommitMessageRequestConverter.convertCommitMessage(node.get("commitMessage"));
        }
        return RequestConverterFunction.fallthrough();
    }

    private static CommitMessageDto convertCommitMessage(JsonNode jsonNode) {
        CommitMessageDto commitMessage = (CommitMessageDto)Jackson.convertValue((Object)jsonNode, CommitMessageDto.class);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commitMessage.summary()) ? 1 : 0) != 0, (Object)"summary should be non-null");
        return commitMessage;
    }
}

