/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.api.v1.ChangeDto;
import com.linecorp.centraldogma.internal.api.v1.CommitMessageDto;
import com.linecorp.centraldogma.internal.api.v1.EntryDto;
import com.linecorp.centraldogma.internal.api.v1.PushResultDto;
import com.linecorp.centraldogma.internal.api.v1.WatchResultDto;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.base.Throwables;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.WatchService;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresWritePermission;
import com.linecorp.centraldogma.server.internal.api.converter.ChangesRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.CommitMessageRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.MergeQueryRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.QueryRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.WatchRequestConverter;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@ProducesJson
@RequiresReadPermission
@RequestConverter(value=CommitMessageRequestConverter.class)
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class ContentServiceV1
extends AbstractService {
    private final WatchService watchService;

    public ContentServiceV1(ProjectManager projectManager, CommandExecutor executor, WatchService watchService) {
        super(projectManager, executor);
        this.watchService = Objects.requireNonNull(watchService, "watchService");
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/list(?<path>(|/.*))$")
    public CompletableFuture<List<EntryDto<?>>> listFiles(@Param(value="path") String path, @Param(value="revision") @Default(value="-1") String revision, Repository repository) {
        String normalizedPath = ContentServiceV1.normalizePath(path);
        Revision normalizedRev = repository.normalizeNow(new Revision(revision));
        CompletableFuture future = new CompletableFuture();
        ContentServiceV1.listFiles(repository, normalizedPath, normalizedRev, false, future);
        return future;
    }

    private static void listFiles(Repository repository, String pathPattern, Revision normalizedRev, boolean withContent, CompletableFuture<List<EntryDto<?>>> result) {
        Map<FindOption<?>, ?> options = withContent ? FindOptions.FIND_ALL_WITH_CONTENT : FindOptions.FIND_ALL_WITHOUT_CONTENT;
        repository.find(normalizedRev, pathPattern, options).handle((entries, thrown) -> {
            if (thrown != null) {
                result.completeExceptionally((Throwable)thrown);
                return null;
            }
            if (Util.isValidFilePath((String)pathPattern) && entries.size() == 1 && ((Entry)entries.values().iterator().next()).type() == EntryType.DIRECTORY) {
                ContentServiceV1.listFiles(repository, pathPattern + "/*", normalizedRev, withContent, result);
            } else {
                result.complete((List)entries.values().stream().map(entry -> DtoConverter.convert(repository, normalizedRev, entry, withContent)).collect(ImmutableList.toImmutableList()));
            }
            return null;
        });
    }

    private static String normalizePath(String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            return "/*";
        }
        if (Util.isValidFilePath((String)path)) {
            return path;
        }
        if (Util.isValidDirPath((String)path)) {
            if (path.endsWith("/")) {
                return path + '*';
            }
            return path + "/*";
        }
        return path;
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/contents")
    @RequiresWritePermission
    public CompletableFuture<PushResultDto> push(@Param(value="revision") @Default(value="-1") String revision, Repository repository, Author author, CommitMessageDto commitMessage, @RequestConverter(value=ChangesRequestConverter.class) Iterable<Change<?>> changes) {
        long commitTimeMillis = System.currentTimeMillis();
        return this.push(commitTimeMillis, author, repository, new Revision(revision), commitMessage, changes).toCompletableFuture().thenApply(rrev -> DtoConverter.convert(rrev, commitTimeMillis));
    }

    private CompletableFuture<Revision> push(long commitTimeMills, Author author, Repository repository, Revision revision, CommitMessageDto commitMessage, Iterable<Change<?>> changes) {
        String summary = commitMessage.summary();
        String detail = commitMessage.detail();
        Markup markup = commitMessage.markup();
        return this.execute(Command.push((Long)commitTimeMills, author, repository.parent().name(), repository.name(), revision, summary, detail, markup, changes));
    }

    @Post(value="/projects/{projectName}/repos/{repoName}/preview")
    public CompletableFuture<Iterable<ChangeDto<?>>> preview(@Param(value="revision") @Default(value="-1") String revision, Repository repository, @RequestConverter(value=ChangesRequestConverter.class) Iterable<Change<?>> changes) {
        CompletableFuture<Map<String, Change<?>>> changesFuture = repository.previewDiff(new Revision(revision), changes);
        return changesFuture.thenApply(previewDiffs -> (Iterable)previewDiffs.values().stream().map(DtoConverter::convert).collect(ImmutableList.toImmutableList()));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/contents(?<path>(|/.*))$")
    public CompletableFuture<?> getFiles(ServiceRequestContext ctx, @Param(value="path") String path, @Param(value="revision") @Default(value="-1") String revision, Repository repository, @RequestConverter(value=WatchRequestConverter.class) Optional<WatchRequestConverter.WatchRequest> watchRequest, @RequestConverter(value=QueryRequestConverter.class) Optional<Query<?>> query) {
        String normalizedPath = ContentServiceV1.normalizePath(path);
        if (watchRequest.isPresent()) {
            Revision lastKnownRevision = watchRequest.get().lastKnownRevision();
            long timeOutMillis = watchRequest.get().timeoutMillis();
            if (query.isPresent()) {
                return this.watchFile(ctx, repository, lastKnownRevision, query.get(), timeOutMillis);
            }
            return this.watchRepository(ctx, repository, lastKnownRevision, normalizedPath, timeOutMillis);
        }
        Revision normalizedRev = repository.normalizeNow(new Revision(revision));
        if (query.isPresent()) {
            return repository.get(normalizedRev, query.get()).handle(HttpApiUtil.returnOrThrow(result -> DtoConverter.convert(repository, normalizedRev, result, true)));
        }
        CompletableFuture future = new CompletableFuture();
        ContentServiceV1.listFiles(repository, normalizedPath, normalizedRev, true, future);
        return future;
    }

    private CompletableFuture<?> watchFile(ServiceRequestContext ctx, Repository repository, Revision lastKnownRevision, Query<?> query, long timeOutMillis) {
        CompletableFuture<Entry<?>> future = this.watchService.watchFile(repository, lastKnownRevision, query, timeOutMillis);
        if (!future.isDone()) {
            ctx.log().whenComplete().thenRun(() -> future.cancel(false));
        }
        return ((CompletableFuture)future.thenApply(entry -> {
            Revision revision = entry.revision();
            EntryDto entryDto = DtoConverter.convert(repository, revision, entry, true);
            return new WatchResultDto(revision, entryDto);
        })).exceptionally(ContentServiceV1::handleWatchFailure);
    }

    private CompletableFuture<?> watchRepository(ServiceRequestContext ctx, Repository repository, Revision lastKnownRevision, String pathPattern, long timeOutMillis) {
        CompletableFuture<Revision> future = this.watchService.watchRepository(repository, lastKnownRevision, pathPattern, timeOutMillis);
        if (!future.isDone()) {
            ctx.log().whenComplete().thenRun(() -> future.cancel(false));
        }
        return ((CompletableFuture)future.thenApply(revision -> new WatchResultDto(revision, null))).exceptionally(ContentServiceV1::handleWatchFailure);
    }

    private static Object handleWatchFailure(Throwable thrown) {
        if (Throwables.getRootCause((Throwable)thrown) instanceof CancellationException) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_MODIFIED);
        }
        return Exceptions.throwUnsafely((Throwable)thrown);
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repos/(?<repoName>[^/]+)/commits(?<revision>(|/.*))$")
    public CompletableFuture<?> listCommits(@Param(value="revision") String revision, @Param(value="path") @Default(value="/**") String path, @Param(value="to") Optional<String> to, @Param(value="maxCommits") Optional<Integer> maxCommits, Repository repository) {
        Revision toRevision;
        Revision fromRevision;
        if (Strings.isNullOrEmpty((String)revision) || "/".equalsIgnoreCase(revision)) {
            fromRevision = Revision.HEAD;
            toRevision = to.map(Revision::new).orElse(Revision.INIT);
        } else {
            fromRevision = new Revision(revision.substring(1));
            toRevision = to.map(Revision::new).orElse(fromRevision);
        }
        RevisionRange range = repository.normalizeNow(fromRevision, toRevision).toDescending();
        int maxCommits0 = maxCommits.map(integer -> Math.min(integer, 1024)).orElse(1024);
        return repository.history(range.from(), range.to(), ContentServiceV1.normalizePath(path), maxCommits0).thenApply(commits -> {
            boolean toList = Strings.isNullOrEmpty((String)revision) || "/".equalsIgnoreCase(revision) || to.isPresent();
            return ContentServiceV1.objectOrList(commits, toList, DtoConverter::convert);
        });
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/compare")
    public CompletableFuture<?> getDiff(@Param(value="pathPattern") @Default(value="/**") String pathPattern, @Param(value="from") @Default(value="1") String from, @Param(value="to") @Default(value="head") String to, Repository repository, @RequestConverter(value=QueryRequestConverter.class) Optional<Query<?>> query) {
        if (query.isPresent()) {
            return repository.diff(new Revision(from), new Revision(to), query.get()).thenApply(DtoConverter::convert);
        }
        return repository.diff(new Revision(from), new Revision(to), ContentServiceV1.normalizePath(pathPattern)).thenApply(changeMap -> (ImmutableList)changeMap.values().stream().map(DtoConverter::convert).collect(ImmutableList.toImmutableList()));
    }

    private static <T> Object objectOrList(Collection<T> collection, boolean toList, Function<T, ?> converter) {
        if (collection.isEmpty()) {
            return ImmutableList.of();
        }
        if (toList) {
            return collection.stream().map(converter).collect(ImmutableList.toImmutableList());
        }
        return converter.apply(Iterables.getOnlyElement(collection));
    }

    @Get(value="/projects/{projectName}/repos/{repoName}/merge")
    public <T> CompletableFuture<?> mergeFiles(@Param(value="revision") @Default(value="-1") String revision, Repository repository, @RequestConverter(value=MergeQueryRequestConverter.class) MergeQuery<T> query) {
        return repository.mergeFiles(new Revision(revision), query).thenApply(DtoConverter::convert);
    }
}

