/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.auth;

import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.auth.AuthException;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedSessionManager
implements SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedSessionManager.class);
    private static final int SESSION_ID_LENGTH = FileBasedSessionManager.nextSessionId().length();
    private static final int SESSION_ID_1ST_PART_LENGTH = 2;
    private static final Pattern SESSION_ID_1ST_PART_PATTERN = Pattern.compile("^[0-9a-f]{2}$");
    private static final int SESSION_ID_2ND_PART_LENGTH = SESSION_ID_LENGTH - 2;
    private static final Pattern SESSION_ID_2ND_PART_PATTERN = Pattern.compile("^[-0-9a-f]{" + SESSION_ID_2ND_PART_LENGTH + "}$");
    private static final Pattern SESSION_ID_PATTERN = Pattern.compile("^[-0-9a-f]{" + SESSION_ID_LENGTH + "}$");
    private static final String ROOT_DIR = "ROOT_DIR";
    private final Path rootDir;
    private final Path tmpDir;
    @Nullable
    private final Scheduler scheduler;

    public FileBasedSessionManager(Path rootDir, @Nullable String cronExpr) throws IOException, SchedulerException {
        this.rootDir = Objects.requireNonNull(rootDir, "rootDir");
        this.tmpDir = rootDir.resolve("tmp");
        Files.createDirectories(this.tmpDir, new FileAttribute[0]);
        if (cronExpr != null) {
            this.scheduler = this.createScheduler(cronExpr);
            this.scheduler.start();
        } else {
            this.scheduler = null;
        }
    }

    private Scheduler createScheduler(String cronExpr) throws SchedulerException {
        String myInstanceId = String.valueOf(this.hashCode());
        Properties cfg = new Properties();
        cfg.setProperty("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        cfg.setProperty("org.quartz.scheduler.instanceName", FileBasedSessionManager.class.getSimpleName() + '@' + myInstanceId);
        cfg.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
        cfg.setProperty("org.quartz.threadPool.threadCount", "1");
        Scheduler scheduler = new StdSchedulerFactory(cfg).getScheduler();
        JobDetail job = JobBuilder.newJob(ExpiredSessionDeletingJob.class).usingJobData(JobDataMapSupport.newJobDataMap((Map)ImmutableMap.of((Object)ROOT_DIR, (Object)this.rootDir))).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(myInstanceId, ExpiredSessionDeletingJob.class.getSimpleName()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpr)).build();
        scheduler.scheduleJob(job, trigger);
        return scheduler;
    }

    @Override
    public String generateSessionId() {
        return FileBasedSessionManager.nextSessionId();
    }

    private static String nextSessionId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public CompletableFuture<Boolean> exists(String sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        return CompletableFuture.completedFuture(FileBasedSessionManager.isSessionFile(this.sessionId2PathOrNull(sessionId)));
    }

    @Override
    public CompletableFuture<Session> get(String sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        Path path = this.sessionId2PathOrNull(sessionId);
        if (!FileBasedSessionManager.isSessionFile(path)) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return CompletableFuture.completedFuture((Session)Jackson.readValue((byte[])Files.readAllBytes(path), Session.class));
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public CompletableFuture<Void> create(Session session) {
        Objects.requireNonNull(session, "session");
        return CompletableFuture.supplyAsync(() -> {
            String sessionId = session.id();
            Path newPath = this.sessionId2Path(sessionId);
            try {
                try {
                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException e) {
                    throw new AuthException(e);
                }
                Path tmpPath = Files.createTempFile(this.tmpDir, null, null, new FileAttribute[0]);
                Files.write(tmpPath, Jackson.writeValueAsBytes((Object)session), new OpenOption[0]);
                Files.move(tmpPath, newPath, StandardCopyOption.ATOMIC_MOVE);
                return null;
            }
            catch (FileAlreadyExistsException unused) {
                throw new AuthException("duplicate session: " + sessionId);
            }
            catch (IOException e) {
                throw new AuthException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> update(Session session) {
        Objects.requireNonNull(session, "session");
        return CompletableFuture.supplyAsync(() -> {
            String sessionId = session.id();
            Path oldPath = this.sessionId2Path(sessionId);
            if (!Files.exists(oldPath, new LinkOption[0])) {
                throw new AuthException("unknown session: " + sessionId);
            }
            try {
                Path newPath = Files.createTempFile(this.tmpDir, null, null, new FileAttribute[0]);
                Files.write(newPath, Jackson.writeValueAsBytes((Object)session), new OpenOption[0]);
                Files.move(newPath, oldPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                return null;
            }
            catch (IOException e) {
                throw new AuthException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> delete(String sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        return CompletableFuture.supplyAsync(() -> {
            try {
                Files.deleteIfExists(this.sessionId2Path(sessionId));
            }
            catch (IOException e) {
                throw new AuthException(e);
            }
            return null;
        });
    }

    @Override
    public void close() throws Exception {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown(true);
        }
    }

    private Path sessionId2Path(String sessionId) {
        Path path = this.sessionId2PathOrNull(sessionId);
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (String)"sessionId: %s (expected: UUID)", (Object)sessionId);
        return path;
    }

    @Nullable
    private Path sessionId2PathOrNull(String sessionId) {
        return FileBasedSessionManager.sessionId2PathOrNull(this.rootDir, sessionId);
    }

    @Nullable
    private static Path sessionId2PathOrNull(Path rootDir, String sessionId) {
        if (!SESSION_ID_PATTERN.matcher(sessionId).matches()) {
            return null;
        }
        return rootDir.resolve(sessionId.substring(0, 2)).resolve(sessionId.substring(2));
    }

    private static boolean isSessionFile(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        int nameCount = path.getNameCount();
        if (nameCount < 2) {
            return false;
        }
        String first = path.getName(nameCount - 2).toString();
        if (!SESSION_ID_1ST_PART_PATTERN.matcher(first).matches()) {
            return false;
        }
        String second = path.getName(nameCount - 1).toString();
        return SESSION_ID_2ND_PART_PATTERN.matcher(second).matches();
    }

    public static class ExpiredSessionDeletingJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                logger.debug("Started {} job.", (Object)ExpiredSessionDeletingJob.class.getSimpleName());
                Path rootDir = (Path)context.getJobDetail().getJobDataMap().get((Object)FileBasedSessionManager.ROOT_DIR);
                Instant now = Instant.now();
                Files.walk(rootDir, 2, new FileVisitOption[0]).filter(x$0 -> FileBasedSessionManager.isSessionFile(x$0)).map(path -> {
                    try {
                        return (Session)Jackson.readValue((byte[])Files.readAllBytes(path), Session.class);
                    }
                    catch (FileNotFoundException | NoSuchFileException iOException) {
                    }
                    catch (Exception e) {
                        logger.warn("Failed to deserialize a session: {}", path, (Object)e);
                        try {
                            Files.deleteIfExists(path);
                            logger.debug("Deleted an invalid session: {}", path);
                        }
                        catch (IOException cause) {
                            logger.warn("Failed to delete an invalid session: {}", path, (Object)cause);
                        }
                    }
                    return null;
                }).filter(Objects::nonNull).filter(session -> now.isAfter(session.expirationTime())).forEach(session -> {
                    Path path = FileBasedSessionManager.sessionId2PathOrNull(rootDir, session.id());
                    if (path == null) {
                        return;
                    }
                    try {
                        Files.deleteIfExists(path);
                        logger.debug("Deleted an expired session: {}", (Object)path);
                    }
                    catch (Throwable cause) {
                        logger.warn("Failed to delete an expired session: {}", (Object)path, (Object)cause);
                    }
                });
                logger.debug("Finished {} job.", (Object)ExpiredSessionDeletingJob.class.getSimpleName());
            }
            catch (Throwable cause) {
                logger.warn("Failed {} job:", (Object)ExpiredSessionDeletingJob.class.getSimpleName(), (Object)cause);
            }
        }
    }
}

