/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceMode;
import com.linecorp.centraldogma.internal.shaded.difflib.DiffUtils;
import com.linecorp.centraldogma.internal.shaded.difflib.Patch;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CacheableCompareTreesCall;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitIdDatabase;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.git.CommitWatchers;
import com.linecorp.centraldogma.server.internal.storage.repository.git.FailFastUtil;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepositoryFormat;
import com.linecorp.centraldogma.server.internal.storage.repository.git.PathPatternFilter;
import com.linecorp.centraldogma.server.storage.StorageException;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitRepository
implements com.linecorp.centraldogma.server.storage.repository.Repository {
    private static final Logger logger = LoggerFactory.getLogger(GitRepository.class);
    static final String R_HEADS_MASTER = "refs/heads/master";
    private static final byte[] EMPTY_BYTE = new byte[0];
    private static final Pattern CR = Pattern.compile("\r", 16);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Project parent;
    private final Executor repositoryWorker;
    @VisibleForTesting
    final RepositoryCache cache;
    private final String name;
    private final Repository jGitRepository;
    private final GitRepositoryFormat format;
    private final CommitIdDatabase commitIdDatabase;
    @VisibleForTesting
    final CommitWatchers commitWatchers = new CommitWatchers();
    private final AtomicReference<Supplier<CentralDogmaException>> closePending = new AtomicReference();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private volatile Revision headRevision;

    @VisibleForTesting
    GitRepository(Project parent, File repoDir, Executor repositoryWorker, long creationTimeMillis, Author author) {
        this(parent, repoDir, GitRepositoryFormat.V1, repositoryWorker, creationTimeMillis, author, null);
    }

    GitRepository(Project parent, File repoDir, GitRepositoryFormat format, Executor repositoryWorker, long creationTimeMillis, Author author, @Nullable RepositoryCache cache) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.name = Objects.requireNonNull(repoDir, "repoDir").getName();
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.format = Objects.requireNonNull(format, "format");
        this.cache = cache;
        Objects.requireNonNull(author, "author");
        RepositoryBuilder repositoryBuilder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).setBare();
        boolean success = false;
        try {
            try (Repository initRepo = repositoryBuilder.build();){
                if (GitRepository.exist(repoDir)) {
                    throw new StorageException("failed to create a repository at: " + repoDir + " (exists already)");
                }
                initRepo.create(true);
                StoredConfig config = initRepo.getConfig();
                if (format == GitRepositoryFormat.V1) {
                    config.setInt("core", null, "repositoryformatversion", 1);
                }
                config.setEnum("core", null, "hidedotfiles", (Enum)CoreConfig.HideDotFiles.FALSE);
                config.setBoolean("core", null, "symlinks", false);
                config.setBoolean("core", null, "filemode", false);
                config.setBoolean("commit", null, "gpgSign", false);
                config.setString("diff", null, "algorithm", "histogram");
                config.setBoolean("diff", null, "renames", false);
                config.save();
            }
            this.jGitRepository = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).build();
            RefUpdate head = this.jGitRepository.updateRef("HEAD");
            head.disableRefLog();
            head.link(R_HEADS_MASTER);
            this.commitIdDatabase = new CommitIdDatabase(this.jGitRepository);
            this.commit0(null, Revision.INIT, creationTimeMillis, author, "Create a new repository", "", Markup.PLAINTEXT, Collections.emptyList(), true);
            this.headRevision = Revision.INIT;
            success = true;
        }
        catch (IOException e) {
            throw new StorageException("failed to create a repository at: " + repoDir, e);
        }
        finally {
            if (!success) {
                this.internalClose();
                GitRepository.deleteCruft(repoDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GitRepository(Project parent, File repoDir, Executor repositoryWorker, @Nullable RepositoryCache cache) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.name = Objects.requireNonNull(repoDir, "repoDir").getName();
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.cache = cache;
        RepositoryBuilder repositoryBuilder = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir)).setBare();
        try {
            this.jGitRepository = repositoryBuilder.build();
            if (!GitRepository.exist(repoDir)) {
                throw new RepositoryNotFoundException(repoDir.toString());
            }
            int formatVersion = this.jGitRepository.getConfig().getInt("core", null, "repositoryformatversion", 0);
            switch (formatVersion) {
                case 0: {
                    this.format = GitRepositoryFormat.V0;
                    break;
                }
                case 1: {
                    this.format = GitRepositoryFormat.V1;
                    break;
                }
                default: {
                    throw new StorageException("unknown repository format version: " + formatVersion);
                }
            }
        }
        catch (IOException e) {
            throw new StorageException("failed to open a repository at: " + repoDir, e);
        }
        boolean success = false;
        try {
            this.headRevision = this.uncachedHeadRevision();
            this.commitIdDatabase = new CommitIdDatabase(this.jGitRepository);
            if (!this.headRevision.equals((Object)this.commitIdDatabase.headRevision())) {
                this.commitIdDatabase.rebuild(this.jGitRepository);
                assert (this.headRevision.equals((Object)this.commitIdDatabase.headRevision()));
            }
            success = true;
        }
        finally {
            if (!success) {
                this.internalClose();
            }
        }
    }

    private static boolean exist(File repoDir) {
        try {
            RepositoryBuilder repositoryBuilder = (RepositoryBuilder)new RepositoryBuilder().setGitDir(repoDir);
            Repository repository = repositoryBuilder.build();
            if (repository.getConfig() instanceof FileBasedConfig) {
                return ((FileBasedConfig)repository.getConfig()).getFile().exists();
            }
            return repository.getDirectory().exists();
        }
        catch (IOException e) {
            throw new StorageException("failed to check if repository exists at " + repoDir, e);
        }
    }

    void close(Supplier<CentralDogmaException> failureCauseSupplier) {
        Objects.requireNonNull(failureCauseSupplier, "failureCauseSupplier");
        if (this.closePending.compareAndSet(null, failureCauseSupplier)) {
            this.repositoryWorker.execute(() -> {
                this.rwLock.writeLock().lock();
                try {
                    if (this.commitIdDatabase != null) {
                        try {
                            this.commitIdDatabase.close();
                        }
                        catch (Exception e) {
                            logger.warn("Failed to close a commitId database:", (Throwable)e);
                        }
                    }
                    if (this.jGitRepository != null) {
                        try {
                            this.jGitRepository.close();
                        }
                        catch (Exception e) {
                            logger.warn("Failed to close a Git repository: {}", (Object)this.jGitRepository.getDirectory(), (Object)e);
                        }
                    }
                }
                finally {
                    this.rwLock.writeLock().unlock();
                    this.commitWatchers.close(failureCauseSupplier);
                    this.closeFuture.complete(null);
                }
            });
        }
        this.closeFuture.join();
    }

    void internalClose() {
        this.close(() -> new CentralDogmaException("should never reach here"));
    }

    @Override
    public Project parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.name;
    }

    public GitRepositoryFormat format() {
        return this.format;
    }

    public boolean needsMigration(GitRepositoryFormat preferredFormat) {
        if (this.format != preferredFormat) {
            return true;
        }
        if (!(this.jGitRepository.getRefDatabase() instanceof RefDirectory)) {
            return true;
        }
        File oldTagFile = new File(this.jGitRepository.getDirectory(), "refs" + File.separatorChar + "tags" + File.separatorChar + "01" + File.separatorChar + "1.0");
        return oldTagFile.exists();
    }

    @Override
    public Revision normalizeNow(Revision revision) {
        return GitRepository.normalizeNow(revision, this.cachedHeadRevision().major());
    }

    private static Revision normalizeNow(Revision revision, int baseMajor) {
        Objects.requireNonNull(revision, "revision");
        int major = revision.major();
        if (major >= 0 ? major > baseMajor : (major = baseMajor + major + 1) <= 0) {
            throw new RevisionNotFoundException(revision);
        }
        if (revision.major() == major) {
            return revision;
        }
        return new Revision(major);
    }

    @Override
    public RevisionRange normalizeNow(Revision from, Revision to) {
        int baseMajor = this.cachedHeadRevision().major();
        return new RevisionRange(GitRepository.normalizeNow(from, baseMajor), GitRepository.normalizeNow(to, baseMajor));
    }

    @Override
    public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "find", revision, pathPattern, options);
            return this.blockingFind(revision, pathPattern, options);
        }, this.repositoryWorker);
    }

    /*
     * Exception decompiling
     */
    private Map<String, Entry<?>> blockingFind(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern, int maxCommits) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "history", from, to, pathPattern, maxCommits);
            return this.blockingHistory(from, to, pathPattern, maxCommits);
        }, this.repositoryWorker);
    }

    private List<Commit> blockingHistory(Revision from, Revision to, String pathPattern, int maxCommits) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        if (maxCommits <= 0) {
            throw new IllegalArgumentException("maxCommits: " + maxCommits + " (expected: > 0)");
        }
        RevisionRange range = this.normalizeNow(from, to);
        RevisionRange descendingRange = range.toDescending();
        this.readLock();
        try {
            ArrayList<Commit> arrayList;
            block26: {
                RevWalk revWalk = this.newRevWalk();
                try {
                    ObjectId fromCommitId = this.commitIdDatabase.get(descendingRange.from());
                    ObjectId toCommitId = this.commitIdDatabase.get(descendingRange.to());
                    revWalk.setTreeFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathPatternFilter.of(pathPattern)));
                    revWalk.markStart(revWalk.parseCommit((AnyObjectId)fromCommitId));
                    RevCommit toCommit = revWalk.parseCommit((AnyObjectId)toCommitId);
                    if (toCommit.getParentCount() != 0) {
                        revWalk.markUninteresting(toCommit.getParent(0));
                    } else {
                        revWalk.markUninteresting(toCommit);
                    }
                    ArrayList<Commit> commitList = new ArrayList<Commit>();
                    boolean needsLastCommit = true;
                    for (RevCommit revCommit : revWalk) {
                        commitList.add(GitRepository.toCommit(revCommit));
                        if (!revCommit.getId().equals((AnyObjectId)toCommitId) && commitList.size() != maxCommits) continue;
                        needsLastCommit = false;
                        break;
                    }
                    if (needsLastCommit && pathPattern.contains("/**")) {
                        try (RevWalk tmpRevWalk = this.newRevWalk();){
                            RevCommit lastRevCommit = tmpRevWalk.parseCommit((AnyObjectId)toCommitId);
                            Revision lastCommitRevision = CommitUtil.extractRevision(lastRevCommit.getFullMessage());
                            if (lastCommitRevision.major() == 1) {
                                commitList.add(GitRepository.toCommit(lastRevCommit));
                            }
                        }
                    }
                    if (!descendingRange.equals((Object)range)) {
                        Collections.reverse(commitList);
                    }
                    arrayList = commitList;
                    if (revWalk == null) break block26;
                }
                catch (Throwable throwable) {
                    try {
                        if (revWalk != null) {
                            try {
                                revWalk.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CentralDogmaException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new StorageException("failed to retrieve the history: " + this.parent.name() + '/' + this.name + " (" + pathPattern + ", " + from + ".." + to + ')', e);
                    }
                }
                revWalk.close();
            }
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private static Commit toCommit(RevCommit revCommit) {
        long when;
        Author author;
        PersonIdent committerIdent = revCommit.getCommitterIdent();
        if (committerIdent == null) {
            author = Author.UNKNOWN;
            when = 0L;
        } else {
            author = new Author(committerIdent.getName(), committerIdent.getEmailAddress());
            when = committerIdent.getWhen().getTime();
        }
        try {
            return CommitUtil.newCommit(author, when, revCommit.getFullMessage());
        }
        catch (Exception e) {
            throw new StorageException("failed to create a Commit", e);
        }
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> diff(Revision from, Revision to, String pathPattern) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            Objects.requireNonNull(from, "from");
            Objects.requireNonNull(to, "to");
            Objects.requireNonNull(pathPattern, "pathPattern");
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "diff", from, to, pathPattern);
            RevisionRange range = this.normalizeNow(from, to).toAscending();
            this.readLock();
            try {
                Map<String, Change<?>> map;
                block12: {
                    RevWalk rw = this.newRevWalk();
                    try {
                        RevTree treeA = rw.parseTree((AnyObjectId)this.commitIdDatabase.get(range.from()));
                        RevTree treeB = rw.parseTree((AnyObjectId)this.commitIdDatabase.get(range.to()));
                        map = this.toChangeMap(this.blockingCompareTreesUncached(treeA, treeB, GitRepository.pathPatternFilterOrTreeFilter(pathPattern)));
                        if (rw == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rw != null) {
                                try {
                                    rw.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (StorageException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new StorageException("failed to parse two trees: range=" + range, e);
                        }
                    }
                    rw.close();
                }
                return map;
            }
            finally {
                this.readUnlock();
            }
        }, this.repositoryWorker);
    }

    private static TreeFilter pathPatternFilterOrTreeFilter(@Nullable String pathPattern) {
        if (pathPattern == null) {
            return TreeFilter.ALL;
        }
        PathPatternFilter pathPatternFilter = PathPatternFilter.of(pathPattern);
        return pathPatternFilter.matchesAll() ? TreeFilter.ALL : pathPatternFilter;
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "previewDiff", baseRevision);
            return this.blockingPreviewDiff(baseRevision, changes);
        }, this.repositoryWorker);
    }

    /*
     * Exception decompiling
     */
    private Map<String, Change<?>> blockingPreviewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Change<?>> toChangeMap(List<DiffEntry> diffEntryList) {
        LinkedHashMap<String, Change<?>> linkedHashMap;
        block24: {
            ObjectReader reader = this.jGitRepository.newObjectReader();
            try {
                LinkedHashMap changeMap = new LinkedHashMap();
                block20: for (DiffEntry diffEntry : diffEntryList) {
                    String oldPath = '/' + diffEntry.getOldPath();
                    String newPath = '/' + diffEntry.getNewPath();
                    switch (diffEntry.getChangeType()) {
                        case MODIFY: {
                            EntryType oldEntryType = EntryType.guessFromPath((String)oldPath);
                            switch (oldEntryType) {
                                case JSON: {
                                    JsonNode newJsonNode;
                                    JsonNode oldJsonNode;
                                    JsonPatch patch;
                                    if (!oldPath.equals(newPath)) {
                                        GitRepository.putChange(changeMap, oldPath, Change.ofRename((String)oldPath, (String)newPath));
                                    }
                                    if ((patch = JsonPatch.generate((JsonNode)(oldJsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getOldId().toObjectId()).getBytes())), (JsonNode)(newJsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes())), (ReplaceMode)ReplaceMode.SAFE)).isEmpty()) continue block20;
                                    GitRepository.putChange(changeMap, newPath, Change.ofJsonPatch((String)newPath, (JsonNode)Jackson.valueToTree((Object)patch)));
                                    continue block20;
                                }
                                case TEXT: {
                                    String oldText = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getOldId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                    String newText = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                    if (!oldPath.equals(newPath)) {
                                        GitRepository.putChange(changeMap, oldPath, Change.ofRename((String)oldPath, (String)newPath));
                                    }
                                    if (oldText.equals(newText)) continue block20;
                                    GitRepository.putChange(changeMap, newPath, Change.ofTextPatch((String)newPath, (String)oldText, (String)newText));
                                    continue block20;
                                }
                            }
                            throw new Error("unexpected old entry type: " + oldEntryType);
                        }
                        case ADD: {
                            EntryType newEntryType = EntryType.guessFromPath((String)newPath);
                            switch (newEntryType) {
                                case JSON: {
                                    JsonNode jsonNode = Jackson.readTree((byte[])reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes());
                                    GitRepository.putChange(changeMap, newPath, Change.ofJsonUpsert((String)newPath, (JsonNode)jsonNode));
                                    continue block20;
                                }
                                case TEXT: {
                                    String text = GitRepository.sanitizeText(new String(reader.open((AnyObjectId)diffEntry.getNewId().toObjectId()).getBytes(), StandardCharsets.UTF_8));
                                    GitRepository.putChange(changeMap, newPath, Change.ofTextUpsert((String)newPath, (String)text));
                                    continue block20;
                                }
                            }
                            throw new Error("unexpected new entry type: " + newEntryType);
                        }
                        case DELETE: {
                            GitRepository.putChange(changeMap, oldPath, Change.ofRemoval((String)oldPath));
                            continue block20;
                        }
                    }
                    throw new Error();
                }
                linkedHashMap = changeMap;
                if (reader == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException("failed to convert list of DiffEntry to Changes map", e);
                }
            }
            reader.close();
        }
        return linkedHashMap;
    }

    private static void putChange(Map<String, Change<?>> changeMap, String path, Change<?> change) {
        Change<?> oldChange = changeMap.put(path, change);
        assert (oldChange == null);
    }

    @Override
    public CompletableFuture<Revision> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "commit", baseRevision, author, summary);
            return this.blockingCommit(baseRevision, commitTimeMillis, author, summary, detail, markup, changes, false);
        }, this.repositoryWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Revision blockingCommit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes, boolean allowEmptyCommit) {
        CommitResult res;
        Objects.requireNonNull(baseRevision, "baseRevision");
        this.rwLock.writeLock().lock();
        try {
            if (this.closePending.get() != null) {
                throw this.closePending.get().get();
            }
            Revision normBaseRevision = this.normalizeNow(baseRevision);
            Revision headRevision = this.cachedHeadRevision();
            if (headRevision.major() != normBaseRevision.major()) {
                throw new ChangeConflictException("invalid baseRevision: " + baseRevision + " (expected: " + headRevision + " or equivalent)");
            }
            res = this.commit0(headRevision, headRevision.forward(1), commitTimeMillis, author, summary, detail, markup, changes, allowEmptyCommit);
            this.headRevision = res.revision;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        this.notifyWatchers(res.revision, res.diffEntries);
        return res.revision;
    }

    /*
     * Exception decompiling
     */
    private CommitResult commit0(@Nullable Revision prevRevision, Revision nextRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes, boolean allowEmpty) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int applyChanges(@Nullable Revision baseRevision, @Nullable ObjectId baseTreeId, DirCache dirCache, Iterable<Change<?>> changes) {
        int numEdits = 0;
        try (ObjectInserter inserter = this.jGitRepository.newObjectInserter();
             ObjectReader reader = this.jGitRepository.newObjectReader();){
            if (baseTreeId != null) {
                DirCacheBuilder builder = dirCache.builder();
                builder.addTree(EMPTY_BYTE, 0, reader, (AnyObjectId)baseTreeId);
                builder.finish();
            }
            for (Change<?> change : changes) {
                String changePath = change.path().substring(1);
                DirCacheEntry oldEntry = dirCache.getEntry(changePath);
                byte[] oldContent = oldEntry != null ? reader.open((AnyObjectId)oldEntry.getObjectId()).getBytes() : null;
                switch (change.type()) {
                    case UPSERT_JSON: {
                        Object oldJsonNode = oldContent != null ? Jackson.readTree((byte[])oldContent) : null;
                        JsonNode newJsonNode = (JsonNode)MoreObjects.firstNonNull((Object)((JsonNode)change.content()), (Object)JsonNodeFactory.instance.nullNode());
                        if (Objects.equals(newJsonNode, oldJsonNode)) break;
                        GitRepository.applyPathEdit(dirCache, new InsertJson(changePath, inserter, newJsonNode));
                        ++numEdits;
                        break;
                    }
                    case UPSERT_TEXT: {
                        String sanitizedOldText = oldContent != null ? GitRepository.sanitizeText(new String(oldContent, StandardCharsets.UTF_8)) : null;
                        String sanitizedNewText = GitRepository.sanitizeText(change.contentAsText());
                        if (sanitizedNewText.equals(sanitizedOldText)) break;
                        GitRepository.applyPathEdit(dirCache, new InsertText(changePath, inserter, sanitizedNewText));
                        ++numEdits;
                        break;
                    }
                    case REMOVE: {
                        if (oldEntry != null) {
                            GitRepository.applyPathEdit(dirCache, (DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(changePath));
                            ++numEdits;
                            break;
                        }
                        if (GitRepository.applyDirectoryEdits(dirCache, changePath, null, change)) {
                            ++numEdits;
                            break;
                        }
                        GitRepository.reportNonExistentEntry(change);
                        break;
                    }
                    case RENAME: {
                        String newPath = ((String)change.content()).substring(1);
                        if (dirCache.getEntry(newPath) != null) {
                            throw new ChangeConflictException("a file exists at the target path: " + change);
                        }
                        if (oldEntry != null) {
                            if (changePath.equals(newPath)) break;
                            DirCacheEditor editor = dirCache.editor();
                            editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(changePath));
                            editor.add((DirCacheEditor.PathEdit)new CopyOldEntry(newPath, oldEntry));
                            editor.finish();
                            ++numEdits;
                            break;
                        }
                        if (GitRepository.applyDirectoryEdits(dirCache, changePath, newPath, change)) {
                            ++numEdits;
                            break;
                        }
                        GitRepository.reportNonExistentEntry(change);
                        break;
                    }
                    case APPLY_JSON_PATCH: {
                        JsonNode newJsonNode;
                        Object oldJsonNode = oldContent != null ? Jackson.readTree((byte[])oldContent) : Jackson.nullNode;
                        try {
                            newJsonNode = JsonPatch.fromJson((JsonNode)((JsonNode)change.content())).apply(oldJsonNode);
                        }
                        catch (Exception e) {
                            throw new ChangeConflictException("failed to apply JSON patch: " + change, (Throwable)e);
                        }
                        if (newJsonNode.equals(oldJsonNode)) break;
                        GitRepository.applyPathEdit(dirCache, new InsertJson(changePath, inserter, newJsonNode));
                        ++numEdits;
                        break;
                    }
                    case APPLY_TEXT_PATCH: {
                        String newText;
                        List sanitizedOldTextLines;
                        String sanitizedOldText;
                        Patch patch = DiffUtils.parseUnifiedDiff((List)Util.stringToLines((String)GitRepository.sanitizeText((String)change.content())));
                        if (oldContent != null) {
                            sanitizedOldText = GitRepository.sanitizeText(new String(oldContent, StandardCharsets.UTF_8));
                            sanitizedOldTextLines = Util.stringToLines((String)sanitizedOldText);
                        } else {
                            sanitizedOldText = null;
                            sanitizedOldTextLines = Collections.emptyList();
                        }
                        try {
                            List newTextLines = DiffUtils.patch(sanitizedOldTextLines, (Patch)patch);
                            if (newTextLines.isEmpty()) {
                                newText = "";
                            } else {
                                StringJoiner joiner = new StringJoiner("\n", "", "\n");
                                for (String line : newTextLines) {
                                    joiner.add(line);
                                }
                                newText = joiner.toString();
                            }
                        }
                        catch (Exception e) {
                            throw new ChangeConflictException("failed to apply text patch: " + change, (Throwable)e);
                        }
                        if (newText.equals(sanitizedOldText)) break;
                        GitRepository.applyPathEdit(dirCache, new InsertText(changePath, inserter, newText));
                        ++numEdits;
                    }
                }
            }
        }
        catch (CentralDogmaException | IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("failed to apply changes on revision " + baseRevision, e);
        }
        return numEdits;
    }

    private static String sanitizeText(String text) {
        if (text.indexOf(13) >= 0) {
            text = CR.matcher(text).replaceAll("");
        }
        if (!text.isEmpty() && !text.endsWith("\n")) {
            text = text + "\n";
        }
        return text;
    }

    private static void reportNonExistentEntry(Change<?> change) {
        throw new ChangeConflictException("non-existent file/directory: " + change);
    }

    private static void applyPathEdit(DirCache dirCache, DirCacheEditor.PathEdit edit) {
        DirCacheEditor e = dirCache.editor();
        e.add(edit);
        e.finish();
    }

    private static boolean applyDirectoryEdits(DirCache dirCache, String oldDir, @Nullable String newDir, Change<?> change) {
        if (!oldDir.endsWith("/")) {
            oldDir = oldDir + '/';
        }
        if (newDir != null && !newDir.endsWith("/")) {
            newDir = newDir + '/';
        }
        byte[] rawOldDir = Constants.encode((String)oldDir);
        byte[] rawNewDir = newDir != null ? Constants.encode((String)newDir) : null;
        int numEntries = dirCache.getEntryCount();
        DirCacheEditor editor = null;
        block0: for (int i = 0; i < numEntries; ++i) {
            DirCacheEntry e = dirCache.getEntry(i);
            byte[] rawPath = e.getRawPath();
            if (rawNewDir != null) {
                boolean conflict = true;
                if (rawPath.length > rawNewDir.length) {
                    for (int j = 0; j < rawNewDir.length; ++j) {
                        if (rawNewDir[j] == rawPath[j]) continue;
                        conflict = false;
                        break;
                    }
                } else if (rawPath.length == rawNewDir.length - 1) {
                    for (int j = 0; j < rawNewDir.length - 1; ++j) {
                        if (rawNewDir[j] == rawPath[j]) continue;
                        conflict = false;
                        break;
                    }
                } else {
                    conflict = false;
                }
                if (conflict) {
                    throw new ChangeConflictException("target directory exists already: " + change);
                }
            }
            if (rawPath.length <= rawOldDir.length) continue;
            for (int j = 0; j < rawOldDir.length; ++j) {
                if (rawOldDir[j] != rawPath[j]) continue block0;
            }
            if (editor == null) {
                editor = dirCache.editor();
                editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(oldDir));
                if (newDir == null) break;
            }
            assert (newDir != null);
            String oldPath = e.getPathString();
            String newPath = newDir + oldPath.substring(oldDir.length());
            editor.add((DirCacheEditor.PathEdit)new CopyOldEntry(newPath, e));
        }
        if (editor != null) {
            editor.finish();
            return true;
        }
        return false;
    }

    private void doRefUpdate(RevWalk revWalk, String ref, ObjectId commitId) throws IOException {
        GitRepository.doRefUpdate(this.jGitRepository, revWalk, ref, commitId);
    }

    @VisibleForTesting
    static void doRefUpdate(Repository jGitRepository, RevWalk revWalk, String ref, ObjectId commitId) throws IOException {
        Ref oldRef;
        if (ref.startsWith("refs/tags/") && (oldRef = jGitRepository.exactRef(ref)) != null) {
            throw new StorageException("tag ref exists already: " + ref);
        }
        RefUpdate refUpdate = jGitRepository.updateRef(ref);
        refUpdate.setNewObjectId((AnyObjectId)commitId);
        RefUpdate.Result res = refUpdate.update(revWalk);
        switch (res) {
            case NEW: 
            case FAST_FORWARD: {
                break;
            }
            default: {
                throw new StorageException("unexpected refUpdate state: " + res);
            }
        }
    }

    @Override
    public CompletableFuture<Revision> findLatestRevision(Revision lastKnownRevision, String pathPattern) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        ServiceRequestContext ctx = FailFastUtil.context();
        return CompletableFuture.supplyAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "findLatestRevision", lastKnownRevision, pathPattern);
            return this.blockingFindLatestRevision(lastKnownRevision, pathPattern);
        }, this.repositoryWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Revision blockingFindLatestRevision(Revision lastKnownRevision, String pathPattern) {
        List<DiffEntry> diffEntries;
        RevisionRange range = this.normalizeNow(lastKnownRevision, Revision.HEAD);
        if (range.from().equals((Object)range.to())) {
            return null;
        }
        if (range.from().major() == 1) {
            Map<String, Entry<?>> entries = this.blockingFind(range.to(), pathPattern, FindOptions.FIND_ONE_WITHOUT_CONTENT);
            return !entries.isEmpty() ? range.to() : null;
        }
        PathPatternFilter filter = PathPatternFilter.of(pathPattern);
        this.readLock();
        try (RevWalk revWalk = this.newRevWalk();){
            RevTree treeA = this.toTree(revWalk, range.from());
            RevTree treeB = this.toTree(revWalk, range.to());
            diffEntries = this.blockingCompareTrees(treeA, treeB);
        }
        finally {
            this.readUnlock();
        }
        for (DiffEntry e : diffEntries) {
            String path;
            switch (e.getChangeType()) {
                case ADD: {
                    path = e.getNewPath();
                    break;
                }
                case MODIFY: 
                case DELETE: {
                    path = e.getOldPath();
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (!filter.matches(path)) continue;
            return range.to();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DiffEntry> blockingCompareTrees(RevTree treeA, RevTree treeB) {
        List<DiffEntry> newDiffEntries;
        List existingDiffEntries;
        if (this.cache == null) {
            return this.blockingCompareTreesUncached(treeA, treeB, TreeFilter.ALL);
        }
        CacheableCompareTreesCall key = new CacheableCompareTreesCall(this, treeA, treeB);
        CompletableFuture<List<DiffEntry>> existingFuture = this.cache.getIfPresent(key);
        if (existingFuture != null && (existingDiffEntries = (List)existingFuture.getNow(null)) != null) {
            return existingDiffEntries;
        }
        Lock lock = key.coarseGrainedLock();
        lock.lock();
        try {
            List existingDiffEntries2;
            existingFuture = this.cache.getIfPresent(key);
            if (existingFuture != null && (existingDiffEntries2 = (List)existingFuture.getNow(null)) != null) {
                List list = existingDiffEntries2;
                return list;
            }
            newDiffEntries = this.blockingCompareTreesUncached(treeA, treeB, TreeFilter.ALL);
            this.cache.put(key, newDiffEntries);
        }
        finally {
            lock.unlock();
        }
        logger.debug("Cache miss: {}", (Object)key);
        return newDiffEntries;
    }

    private List<DiffEntry> blockingCompareTreesUncached(@Nullable RevTree treeA, @Nullable RevTree treeB, TreeFilter filter) {
        this.readLock();
        try {
            ImmutableList immutableList;
            DiffFormatter diffFormatter = new DiffFormatter(null);
            try {
                diffFormatter.setRepository(this.jGitRepository);
                diffFormatter.setPathFilter(filter);
                immutableList = ImmutableList.copyOf((Collection)diffFormatter.scan(treeA, treeB));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        diffFormatter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageException("failed to compare two trees: " + treeA + " vs. " + treeB, e);
                }
            }
            diffFormatter.close();
            return immutableList;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public CompletableFuture<Revision> watch(Revision lastKnownRevision, String pathPattern) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        ServiceRequestContext ctx = FailFastUtil.context();
        Revision normLastKnownRevision = this.normalizeNow(lastKnownRevision);
        CompletableFuture<Revision> future = new CompletableFuture<Revision>();
        CompletableFuture.runAsync(() -> {
            FailFastUtil.failFastIfTimedOut(this, logger, ctx, "watch", lastKnownRevision, pathPattern);
            this.readLock();
            try {
                Revision latestRevision = this.blockingFindLatestRevision(normLastKnownRevision, pathPattern);
                if (latestRevision != null) {
                    future.complete(latestRevision);
                } else {
                    this.commitWatchers.add(normLastKnownRevision, pathPattern, future);
                }
            }
            finally {
                this.readUnlock();
            }
        }, this.repositoryWorker).exceptionally(cause -> {
            future.completeExceptionally((Throwable)cause);
            return null;
        });
        return future;
    }

    private void notifyWatchers(Revision newRevision, List<DiffEntry> diffEntries) {
        block4: for (DiffEntry entry : diffEntries) {
            switch (entry.getChangeType()) {
                case ADD: {
                    this.commitWatchers.notify(newRevision, entry.getNewPath());
                    continue block4;
                }
                case MODIFY: 
                case DELETE: {
                    this.commitWatchers.notify(newRevision, entry.getOldPath());
                    continue block4;
                }
            }
            throw new Error();
        }
    }

    private Revision cachedHeadRevision() {
        return this.headRevision;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Revision uncachedHeadRevision() {
        try (RevWalk revWalk = this.newRevWalk();){
            ObjectId headRevisionId = this.jGitRepository.resolve(R_HEADS_MASTER);
            if (headRevisionId == null) throw new StorageException("failed to determine the HEAD: " + this.parent.name() + '/' + this.name);
            RevCommit revCommit = revWalk.parseCommit((AnyObjectId)headRevisionId);
            Revision revision = CommitUtil.extractRevision(revCommit.getFullMessage());
            return revision;
        }
        catch (CentralDogmaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException("failed to get the current revision", e);
        }
    }

    private RevTree toTree(RevWalk revWalk, Revision revision) {
        ObjectId commitId = this.commitIdDatabase.get(revision);
        try {
            return revWalk.parseCommit((AnyObjectId)commitId).getTree();
        }
        catch (IOException e) {
            throw new StorageException("failed to parse a commit: " + commitId, e);
        }
    }

    private RevWalk newRevWalk() {
        RevWalk revWalk = new RevWalk(this.jGitRepository);
        GitRepository.configureRevWalk(revWalk);
        return revWalk;
    }

    private static RevWalk newRevWalk(ObjectReader reader) {
        RevWalk revWalk = new RevWalk(reader);
        GitRepository.configureRevWalk(revWalk);
        return revWalk;
    }

    private static void configureRevWalk(RevWalk revWalk) {
        revWalk.setRewriteParents(false);
    }

    private void readLock() {
        this.rwLock.readLock().lock();
        if (this.closePending.get() != null) {
            this.rwLock.readLock().unlock();
            throw this.closePending.get().get();
        }
    }

    private void readUnlock() {
        this.rwLock.readLock().unlock();
    }

    public void cloneTo(File newRepoDir) {
        this.cloneTo(newRepoDir, GitRepositoryFormat.V1);
    }

    public void cloneTo(File newRepoDir, BiConsumer<Integer, Integer> progressListener) {
        this.cloneTo(newRepoDir, GitRepositoryFormat.V1, progressListener);
    }

    public void cloneTo(File newRepoDir, GitRepositoryFormat format) {
        this.cloneTo(newRepoDir, format, (current, total) -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneTo(File newRepoDir, GitRepositoryFormat format, BiConsumer<Integer, Integer> progressListener) {
        Objects.requireNonNull(newRepoDir, "newRepoDir");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(progressListener, "progressListener");
        Revision endRevision = this.normalizeNow(Revision.HEAD);
        GitRepository newRepo = new GitRepository(this.parent, newRepoDir, format, this.repositoryWorker, this.creationTimeMillis(), this.author(), this.cache);
        progressListener.accept(1, endRevision.major());
        boolean success = false;
        try {
            Revision previousNonEmptyRevision = null;
            int i = 2;
            while (i <= endRevision.major()) {
                int batch = 16;
                List<Commit> commits = this.blockingHistory(new Revision(i), new Revision(Math.min(endRevision.major(), i + 16 - 1)), "/**", 16);
                Preconditions.checkState((!commits.isEmpty() ? 1 : 0) != 0, (Object)"empty commits");
                if (previousNonEmptyRevision == null) {
                    previousNonEmptyRevision = commits.get(0).revision().backward(1);
                }
                for (Commit c : commits) {
                    Revision revision = c.revision();
                    Preconditions.checkState((revision.major() == i ? 1 : 0) != 0, (String)"mismatching revision: %s (expected: %s)", (int)revision.major(), (int)i);
                    Revision baseRevision = revision.backward(1);
                    Collection<Change<?>> changes = this.diff(previousNonEmptyRevision, revision, "/**").join().values();
                    try {
                        newRepo.blockingCommit(baseRevision, c.when(), c.author(), c.summary(), c.detail(), c.markup(), changes, false);
                        previousNonEmptyRevision = revision;
                    }
                    catch (RedundantChangeException e) {
                        newRepo.blockingCommit(baseRevision, c.when(), c.author(), c.summary(), c.detail(), c.markup(), changes, true);
                    }
                    progressListener.accept(i, endRevision.major());
                    ++i;
                }
            }
            success = true;
        }
        finally {
            newRepo.internalClose();
            if (!success) {
                GitRepository.deleteCruft(newRepoDir);
            }
        }
    }

    private static void deleteCruft(File repoDir) {
        try {
            Util.deleteFileTree((File)repoDir);
        }
        catch (IOException e) {
            logger.error("Failed to delete a half-created repository at: {}", (Object)repoDir, (Object)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dir", (Object)this.jGitRepository.getDirectory()).add("format", (Object)this.format).toString();
    }

    private static final class CommitResult {
        final Revision revision;
        final List<DiffEntry> diffEntries;

        CommitResult(Revision revision, List<DiffEntry> diffEntries) {
            this.revision = revision;
            this.diffEntries = diffEntries;
        }
    }

    private static final class InsertJson
    extends DirCacheEditor.PathEdit {
        private final ObjectInserter inserter;
        private final JsonNode jsonNode;

        InsertJson(String entryPath, ObjectInserter inserter, JsonNode jsonNode) {
            super(entryPath);
            this.inserter = inserter;
            this.jsonNode = jsonNode;
        }

        public void apply(DirCacheEntry ent) {
            try {
                ent.setObjectId((AnyObjectId)this.inserter.insert(3, Jackson.writeValueAsBytes((Object)this.jsonNode)));
                ent.setFileMode(FileMode.REGULAR_FILE);
            }
            catch (IOException e) {
                throw new StorageException("failed to create a new JSON blob", e);
            }
        }
    }

    private static final class InsertText
    extends DirCacheEditor.PathEdit {
        private final ObjectInserter inserter;
        private final String text;

        InsertText(String entryPath, ObjectInserter inserter, String text) {
            super(entryPath);
            this.inserter = inserter;
            this.text = text;
        }

        public void apply(DirCacheEntry ent) {
            try {
                ent.setObjectId((AnyObjectId)this.inserter.insert(3, this.text.getBytes(StandardCharsets.UTF_8)));
                ent.setFileMode(FileMode.REGULAR_FILE);
            }
            catch (IOException e) {
                throw new StorageException("failed to create a new text blob", e);
            }
        }
    }

    private static final class CopyOldEntry
    extends DirCacheEditor.PathEdit {
        private final DirCacheEntry oldEntry;

        CopyOldEntry(String entryPath, DirCacheEntry oldEntry) {
            super(entryPath);
            this.oldEntry = oldEntry;
        }

        public void apply(DirCacheEntry ent) {
            ent.setFileMode(this.oldEntry.getFileMode());
            ent.setObjectId((AnyObjectId)this.oldEntry.getObjectId());
        }
    }
}

