/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.CacheableCall;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class CacheableQueryCall
extends CacheableCall<Entry<?>> {
    static final Entry<?> EMPTY = Entry.ofDirectory((Revision)new Revision(Integer.MAX_VALUE), (String)"/");
    final Revision revision;
    final Query<?> query;
    final int hashCode;

    CacheableQueryCall(Repository repo, Revision revision, Query<?> query) {
        super(repo);
        this.revision = Objects.requireNonNull(revision, "revision");
        this.query = Objects.requireNonNull(query, "query");
        this.hashCode = Objects.hash(revision, query) * 31 + System.identityHashCode(repo);
        assert (!revision.isRelative());
    }

    @Override
    protected int weigh(Entry<?> value) {
        int weight = 0;
        weight += this.query.path().length();
        for (String e : this.query.expressions()) {
            weight += e.length();
        }
        if (value != null && value.hasContent()) {
            weight += value.contentAsText().length();
        }
        return weight;
    }

    @Override
    public CompletableFuture<Entry<?>> execute() {
        return this.repo().getOrNull(this.revision, this.query).thenApply(e -> (Entry)MoreObjects.firstNonNull((Object)e, EMPTY));
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableQueryCall that = (CacheableQueryCall)o;
        return this.revision.equals((Object)that.revision) && this.query.equals(that.query);
    }

    @Override
    protected void toString(MoreObjects.ToStringHelper helper) {
        helper.add("revision", (Object)this.revision).add("query", this.query);
    }
}

