/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.CacheableCall;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class CacheableMultiDiffCall
extends CacheableCall<Map<String, Change<?>>> {
    final Revision from;
    final Revision to;
    final String pathPattern;
    final int hashCode;

    CacheableMultiDiffCall(Repository repo, Revision from, Revision to, String pathPattern) {
        super(repo);
        this.from = Objects.requireNonNull(from, "from");
        this.to = Objects.requireNonNull(to, "to");
        this.pathPattern = Objects.requireNonNull(pathPattern, "pathPattern");
        this.hashCode = Objects.hash(from, to, pathPattern) * 31 + System.identityHashCode(repo);
        assert (!from.isRelative());
        assert (!to.isRelative());
    }

    @Override
    protected int weigh(Map<String, Change<?>> value) {
        int weight = 0;
        weight += this.pathPattern.length();
        for (Change<?> e : value.values()) {
            weight += e.path().length();
            String content = e.contentAsText();
            if (content == null) continue;
            weight += content.length();
        }
        return weight;
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> execute() {
        return this.repo().diff(this.from, this.to, this.pathPattern);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableMultiDiffCall that = (CacheableMultiDiffCall)o;
        return this.from.equals((Object)that.from) && this.to.equals((Object)that.to) && this.pathPattern.equals(that.pathPattern);
    }

    @Override
    protected void toString(MoreObjects.ToStringHelper helper) {
        helper.add("from", (Object)this.from).add("to", (Object)this.to).add("pathPattern", (Object)this.pathPattern);
    }
}

