/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.RepositoryCommand;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class PushCommand
extends RepositoryCommand<Revision> {
    private final Revision baseRevision;
    private final String summary;
    private final String detail;
    private final Markup markup;
    private final List<Change<?>> changes;

    @JsonCreator
    PushCommand(@JsonProperty(value="timestamp") @Nullable Long timestamp, @JsonProperty(value="author") @Nullable Author author, @JsonProperty(value="projectName") String projectName, @JsonProperty(value="repositoryName") String repositoryName, @JsonProperty(value="baseRevision") Revision baseRevision, @JsonProperty(value="summary") String summary, @JsonProperty(value="detail") String detail, @JsonProperty(value="markup") Markup markup, @JsonProperty(value="changes") Iterable<Change<?>> changes) {
        super(CommandType.PUSH, timestamp, author, projectName, repositoryName);
        this.baseRevision = Objects.requireNonNull(baseRevision, "baseRevision");
        this.summary = Objects.requireNonNull(summary, "summary");
        this.detail = Objects.requireNonNull(detail, "detail");
        this.markup = Objects.requireNonNull(markup, "markup");
        Objects.requireNonNull(changes, "changes");
        this.changes = Collections.unmodifiableList(StreamSupport.stream(changes.spliterator(), false).collect(Collectors.toList()));
    }

    @JsonProperty
    public Revision baseRevision() {
        return this.baseRevision;
    }

    @JsonProperty
    public String summary() {
        return this.summary;
    }

    @JsonProperty
    public String detail() {
        return this.detail;
    }

    @JsonProperty
    public Markup markup() {
        return this.markup;
    }

    @JsonProperty
    public List<Change<?>> changes() {
        return this.changes;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PushCommand)) {
            return false;
        }
        PushCommand that = (PushCommand)obj;
        return super.equals(that) && this.baseRevision.equals((Object)that.baseRevision) && this.summary.equals(that.summary) && this.detail.equals(that.detail) && this.markup == that.markup && this.changes.equals(that.changes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseRevision, this.summary, this.detail, this.markup, this.changes) * 31 + super.hashCode();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("baseRevision", (Object)this.baseRevision).add("summary", (Object)this.summary).add("markup", (Object)this.markup);
    }
}

