/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.FileConverter;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.CentralDogma;
import com.linecorp.centraldogma.server.CentralDogmaBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final File DEFAULT_DATA_DIR = new File(System.getProperty("user.dir", ".") + File.separatorChar + "data");
    private static final File DEFAULT_CONFIG_FILE = new File(System.getProperty("user.dir", ".") + File.separatorChar + "conf" + File.separatorChar + "dogma.json");
    private static final File DEFAULT_PID_FILE = new File(System.getProperty("user.dir", ".") + File.separatorChar + "dogma.pid");
    @Nullable
    @Parameter(names={"-config"}, description="The path to the config file", converter=FileConverter.class)
    private File configFile;
    @Nullable
    @Parameter(names={"-pidfile"}, description="The path to the file containing the pid of the server (defaults to ./dogma.pid)", converter=FileConverter.class)
    private File pidFile;
    @Nullable
    @Parameter(names={"-help", "-h"}, description="Prints the usage", help=true)
    private Boolean help;
    private State state = State.NONE;
    @Nullable
    private CentralDogma dogma;
    @Nullable
    private PidFile procIdFile;
    private boolean procIdFileCreated;

    private Main(String[] args) {
        JCommander commander = new JCommander((Object)this);
        commander.setProgramName(this.getClass().getName());
        commander.parse(args);
        if (this.help != null && this.help.booleanValue()) {
            commander.usage();
        } else {
            this.procIdFile = new PidFile((File)MoreObjects.firstNonNull((Object)this.pidFile, (Object)DEFAULT_PID_FILE));
            this.state = State.INITIALIZED;
        }
    }

    synchronized void start() throws Exception {
        switch (this.state) {
            case NONE: {
                throw new IllegalStateException("not initialized");
            }
            case STARTED: {
                throw new IllegalStateException("started already");
            }
            case DESTROYED: {
                throw new IllegalStateException("can't start after destruction");
            }
        }
        File configFile = Main.findConfigFile(this.configFile, DEFAULT_CONFIG_FILE);
        CentralDogma dogma = configFile == null ? new CentralDogmaBuilder(DEFAULT_DATA_DIR).build() : CentralDogma.forConfig(configFile);
        dogma.start().get();
        this.dogma = dogma;
        this.state = State.STARTED;
        assert (this.procIdFile != null);
        this.procIdFile.create();
        this.procIdFileCreated = true;
    }

    @Nullable
    private static File findConfigFile(@Nullable File file, File defaultFile) {
        if (file != null) {
            if (file.isFile() && file.canRead()) {
                return file;
            }
            throw new IllegalStateException("cannot access the specified config file: " + file);
        }
        if (defaultFile.isFile() && defaultFile.canRead()) {
            return defaultFile;
        }
        return null;
    }

    synchronized void stop() throws Exception {
        switch (this.state) {
            case NONE: 
            case INITIALIZED: 
            case STOPPED: {
                return;
            }
            case DESTROYED: {
                throw new IllegalStateException("can't stop after destruction");
            }
        }
        CentralDogma dogma = this.dogma;
        assert (dogma != null);
        this.dogma = null;
        dogma.stop().get();
        this.state = State.STOPPED;
    }

    void destroy() {
        switch (this.state) {
            case NONE: {
                return;
            }
            case STARTED: {
                throw new IllegalStateException("can't destroy while running");
            }
            case DESTROYED: {
                return;
            }
        }
        assert (this.procIdFile != null);
        if (this.procIdFileCreated) {
            try {
                this.procIdFile.destroy();
            }
            catch (IOException e) {
                logger.warn("Failed to destroy the PID file:", (Throwable)e);
            }
        }
        this.state = State.DESTROYED;
    }

    public static void main(String[] args) throws Exception {
        final Main main = new Main(args);
        Runtime.getRuntime().addShutdownHook(new Thread("Central Dogma shutdown hook"){

            @Override
            public void run() {
                try {
                    main.stop();
                }
                catch (Exception e) {
                    logger.warn("Failed to stop the Central Dogma:", (Throwable)e);
                }
                try {
                    main.destroy();
                }
                catch (Exception e) {
                    logger.warn("Failed to destroy the Central Dogma:", (Throwable)e);
                }
            }
        });
        if (main.state != State.INITIALIZED) {
            System.exit(1);
            return;
        }
        try {
            main.start();
        }
        catch (Throwable cause) {
            logger.error("Failed to start the Central Dogma:", cause);
            System.exit(1);
        }
    }

    static enum State {
        NONE,
        INITIALIZED,
        STARTED,
        STOPPED,
        DESTROYED;

    }

    static final class PidFile {
        private final File file;

        private PidFile(File file) {
            this.file = file;
        }

        void create() throws IOException {
            if (this.file.exists()) {
                throw new IllegalStateException("Failed to create a PID file. A file already exists: " + this.file.getPath());
            }
            int pid = SystemInfo.pid();
            Path temp = Files.createTempFile("central-dogma", ".tmp", new FileAttribute[0]);
            Files.write(temp, Integer.toString(pid).getBytes(), new OpenOption[0]);
            try {
                Files.move(temp, this.file.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(temp, this.file.toPath(), new CopyOption[0]);
            }
            logger.debug("A PID file has been created: {}", (Object)this.file);
        }

        void destroy() throws IOException {
            if (Files.deleteIfExists(this.file.toPath())) {
                logger.debug("Successfully deleted the PID file: {}", (Object)this.file);
            }
        }
    }
}

