/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.git;

import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.server.internal.storage.repository.git.PathPatternFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommitWatchers {
    private static final Logger logger = LoggerFactory.getLogger(CommitWatchers.class);
    @VisibleForTesting
    final Map<PathPatternFilter, Set<Watch>> watchesMap = new WatcherMap(8192);

    CommitWatchers() {
    }

    void add(Revision lastKnownRev, String pathPattern, CompletableFuture<Revision> future) {
        this.add0(PathPatternFilter.of(pathPattern), new Watch(lastKnownRev, future));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add0(PathPatternFilter pathPattern, Watch watch) {
        Map<PathPatternFilter, Set<Watch>> map = this.watchesMap;
        synchronized (map) {
            Set watches = this.watchesMap.computeIfAbsent(pathPattern, k -> Collections.newSetFromMap(new IdentityHashMap()));
            watches.add(watch);
        }
        watch.future.whenComplete((revision, cause) -> {
            if (watch.removed) {
                return;
            }
            Map<PathPatternFilter, Set<Watch>> map = this.watchesMap;
            synchronized (map) {
                Set<Watch> watches = this.watchesMap.get((Object)pathPattern);
                watches.remove(watch);
                if (watches.isEmpty()) {
                    this.watchesMap.remove((Object)pathPattern);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(Revision revision, String path) {
        List<Watch> eligibleWatches = null;
        Map<PathPatternFilter, Set<Watch>> map = this.watchesMap;
        synchronized (map) {
            if (this.watchesMap.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<PathPatternFilter, Set<Watch>>> mapIt = this.watchesMap.entrySet().iterator();
            while (mapIt.hasNext()) {
                Map.Entry<PathPatternFilter, Set<Watch>> entry = mapIt.next();
                if (!entry.getKey().matches(path)) continue;
                Set<Watch> watches = entry.getValue();
                Iterator<Watch> i = watches.iterator();
                while (i.hasNext()) {
                    Watch w = i.next();
                    Revision lastKnownRevision = w.lastKnownRevision;
                    if (lastKnownRevision.compareTo(revision) < 0) {
                        eligibleWatches = CommitWatchers.move(eligibleWatches, i, w);
                        continue;
                    }
                    CommitWatchers.logIneligibleFuture(lastKnownRevision, revision);
                }
                if (!watches.isEmpty()) continue;
                mapIt.remove();
            }
        }
        if (eligibleWatches == null) {
            return;
        }
        int numEligiblePromises = eligibleWatches.size();
        for (int i = 0; i < numEligiblePromises; ++i) {
            ((Watch)eligibleWatches.get((int)i)).future.complete(revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Supplier<CentralDogmaException> causeSupplier) {
        List<Watch> eligibleWatches = null;
        Map<PathPatternFilter, Set<Watch>> map = this.watchesMap;
        synchronized (map) {
            for (Set<Watch> watches : this.watchesMap.values()) {
                Iterator<Watch> i = watches.iterator();
                while (i.hasNext()) {
                    Watch w = i.next();
                    eligibleWatches = CommitWatchers.move(eligibleWatches, i, w);
                }
            }
        }
        if (eligibleWatches == null) {
            return;
        }
        CentralDogmaException cause = causeSupplier.get();
        int numEligiblePromises = eligibleWatches.size();
        for (int i = 0; i < numEligiblePromises; ++i) {
            eligibleWatches.get((int)i).future.completeExceptionally(cause);
        }
    }

    private static List<Watch> move(@Nullable List<Watch> watches, Iterator<Watch> i, Watch w) {
        i.remove();
        w.removed = true;
        if (watches == null) {
            watches = new ArrayList<Watch>();
        }
        watches.add(w);
        return watches;
    }

    private static void logIneligibleFuture(Revision lastKnownRevision, Revision newRevision) {
        logger.debug("Not notifying a future with same or newer lastKnownRevision: {} (newRevision: {})", (Object)lastKnownRevision, (Object)newRevision);
    }

    private static final class WatcherMap
    extends LinkedHashMap<PathPatternFilter, Set<Watch>> {
        private static final long serialVersionUID = 6793455658134063005L;
        private final int maxEntries;

        WatcherMap(int maxEntries) {
            super(maxEntries, 0.75f, true);
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<PathPatternFilter, Set<Watch>> eldest) {
            return this.size() > this.maxEntries && eldest.getValue().isEmpty();
        }
    }

    private static final class Watch {
        final Revision lastKnownRevision;
        final CompletableFuture<Revision> future;
        volatile boolean removed;

        Watch(Revision lastKnownRevision, CompletableFuture<Revision> future) {
            this.lastKnownRevision = lastKnownRevision;
            this.future = future;
        }
    }
}

