/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProducesJson;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchOperation;
import com.linecorp.centraldogma.internal.jsonpatch.ReplaceOperation;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRole;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.PerRolePermissions;
import com.linecorp.centraldogma.server.metadata.Permission;
import com.linecorp.centraldogma.server.metadata.ProjectRole;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.User;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@ProducesJson
@RequiresRole(roles={ProjectRole.OWNER})
@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class MetadataApiService {
    private static final TypeReference<Collection<Permission>> permissionsTypeRef = new TypeReference<Collection<Permission>>(){};
    private final MetadataService mds;
    private final Function<String, String> loginNameNormalizer;

    public MetadataApiService(MetadataService mds, Function<String, String> loginNameNormalizer) {
        this.mds = Objects.requireNonNull(mds, "mds");
        this.loginNameNormalizer = Objects.requireNonNull(loginNameNormalizer, "loginNameNormalizer");
    }

    @Post(value="/metadata/{projectName}/members")
    public CompletableFuture<Revision> addMember(@Param String projectName, IdentifierWithRole request, Author author) {
        ProjectRole role = MetadataApiService.toProjectRole(request.role());
        User member = new User(this.loginNameNormalizer.apply(request.id()));
        return this.mds.addMember(author, projectName, member, role);
    }

    @Patch(value="/metadata/{projectName}/members/{memberId}")
    @Consumes(value="application/json-patch+json")
    public CompletableFuture<Revision> updateMember(@Param String projectName, @Param String memberId, JsonPatch jsonPatch, Author author) {
        ReplaceOperation operation = MetadataApiService.ensureSingleReplaceOperation(jsonPatch, "/role");
        ProjectRole role = ProjectRole.of(operation.value());
        User member = new User(this.loginNameNormalizer.apply(MetadataApiService.urlDecode(memberId)));
        return this.mds.getMember(projectName, member).thenCompose(unused -> this.mds.updateMemberRole(author, projectName, member, role));
    }

    @Delete(value="/metadata/{projectName}/members/{memberId}")
    public CompletableFuture<Revision> removeMember(@Param String projectName, @Param String memberId, Author author) {
        User member = new User(this.loginNameNormalizer.apply(MetadataApiService.urlDecode(memberId)));
        return this.mds.getMember(projectName, member).thenCompose(unused -> this.mds.removeMember(author, projectName, member));
    }

    @Post(value="/metadata/{projectName}/tokens")
    public CompletableFuture<Revision> addToken(@Param String projectName, IdentifierWithRole request, Author author) {
        ProjectRole role = MetadataApiService.toProjectRole(request.role());
        return this.mds.findTokenByAppId(request.id()).thenCompose(token -> this.mds.addToken(author, projectName, token.appId(), role));
    }

    @Patch(value="/metadata/{projectName}/tokens/{appId}")
    @Consumes(value="application/json-patch+json")
    public CompletableFuture<Revision> updateTokenRole(@Param String projectName, @Param String appId, JsonPatch jsonPatch, Author author) {
        ReplaceOperation operation = MetadataApiService.ensureSingleReplaceOperation(jsonPatch, "/role");
        ProjectRole role = ProjectRole.of(operation.value());
        return this.mds.findTokenByAppId(appId).thenCompose(token -> this.mds.updateTokenRole(author, projectName, (Token)token, role));
    }

    @Delete(value="/metadata/{projectName}/tokens/{appId}")
    public CompletableFuture<Revision> removeToken(@Param String projectName, @Param String appId, Author author) {
        return this.mds.findTokenByAppId(appId).thenCompose(token -> this.mds.removeToken(author, projectName, token.appId()));
    }

    @Post(value="/metadata/{projectName}/repos/{repoName}/perm/role")
    public CompletableFuture<Revision> updateRolePermission(@Param String projectName, @Param String repoName, PerRolePermissions newPermission, Author author) {
        return this.mds.updatePerRolePermissions(author, projectName, repoName, newPermission);
    }

    @Post(value="/metadata/{projectName}/repos/{repoName}/perm/users")
    public CompletableFuture<Revision> addSpecificUserPermission(@Param String projectName, @Param String repoName, IdentifierWithPermissions memberWithPermissions, Author author) {
        User member = new User(this.loginNameNormalizer.apply(memberWithPermissions.id()));
        return this.mds.addPerUserPermission(author, projectName, repoName, member, memberWithPermissions.permissions());
    }

    @Patch(value="/metadata/{projectName}/repos/{repoName}/perm/users/{memberId}")
    @Consumes(value="application/json-patch+json")
    public CompletableFuture<Revision> updateSpecificUserPermission(@Param String projectName, @Param String repoName, @Param String memberId, JsonPatch jsonPatch, Author author) {
        ReplaceOperation operation = MetadataApiService.ensureSingleReplaceOperation(jsonPatch, "/permissions");
        Collection permissions = (Collection)Jackson.convertValue((Object)operation.value(), permissionsTypeRef);
        User member = new User(this.loginNameNormalizer.apply(MetadataApiService.urlDecode(memberId)));
        return this.mds.findPermissions(projectName, repoName, member).thenCompose(unused -> this.mds.updatePerUserPermission(author, projectName, repoName, member, permissions));
    }

    @Delete(value="/metadata/{projectName}/repos/{repoName}/perm/users/{memberId}")
    public CompletableFuture<Revision> removeSpecificUserPermission(@Param String projectName, @Param String repoName, @Param String memberId, Author author) {
        User member = new User(this.loginNameNormalizer.apply(MetadataApiService.urlDecode(memberId)));
        return this.mds.findPermissions(projectName, repoName, member).thenCompose(unused -> this.mds.removePerUserPermission(author, projectName, repoName, member));
    }

    @Post(value="/metadata/{projectName}/repos/{repoName}/perm/tokens")
    public CompletableFuture<Revision> addSpecificTokenPermission(@Param String projectName, @Param String repoName, IdentifierWithPermissions tokenWithPermissions, Author author) {
        return this.mds.addPerTokenPermission(author, projectName, repoName, tokenWithPermissions.id(), tokenWithPermissions.permissions());
    }

    @Patch(value="/metadata/{projectName}/repos/{repoName}/perm/tokens/{appId}")
    @Consumes(value="application/json-patch+json")
    public CompletableFuture<Revision> updateSpecificTokenPermission(@Param String projectName, @Param String repoName, @Param String appId, JsonPatch jsonPatch, Author author) {
        ReplaceOperation operation = MetadataApiService.ensureSingleReplaceOperation(jsonPatch, "/permissions");
        Collection permissions = (Collection)Jackson.convertValue((Object)operation.value(), permissionsTypeRef);
        return this.mds.findTokenByAppId(appId).thenCompose(token -> this.mds.updatePerTokenPermission(author, projectName, repoName, appId, permissions));
    }

    @Delete(value="/metadata/{projectName}/repos/{repoName}/perm/tokens/{appId}")
    public CompletableFuture<Revision> removeSpecificTokenPermission(@Param String projectName, @Param String repoName, @Param String appId, Author author) {
        return this.mds.findTokenByAppId(appId).thenCompose(token -> this.mds.removePerTokenPermission(author, projectName, repoName, appId));
    }

    private static ReplaceOperation ensureSingleReplaceOperation(JsonPatch patch, String expectedPath) {
        List operations = patch.operations();
        Preconditions.checkArgument((operations.size() == 1 ? 1 : 0) != 0, (Object)("Should be a single JSON patch operation in the list: " + operations.size()));
        JsonPatchOperation operation = (JsonPatchOperation)patch.operations().get(0);
        Preconditions.checkArgument((boolean)(operation instanceof ReplaceOperation), (Object)("Should be a replace operation: " + operation));
        Preconditions.checkArgument((boolean)expectedPath.equals(operation.path().toString()), (Object)("Invalid path value: " + operation.path()));
        return (ReplaceOperation)operation;
    }

    private static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return (String)Exceptions.throwUnsafely((Throwable)e);
        }
    }

    private static ProjectRole toProjectRole(String roleStr) {
        ProjectRole role = ProjectRole.valueOf(Objects.requireNonNull(roleStr, "roleStr"));
        Preconditions.checkArgument((role == ProjectRole.OWNER || role == ProjectRole.MEMBER ? 1 : 0) != 0, (Object)("Invalid role: " + (Object)((Object)role) + " (expected: '" + (Object)((Object)ProjectRole.OWNER) + "' or '" + (Object)((Object)ProjectRole.MEMBER) + "')"));
        return role;
    }

    static final class IdentifierWithRole {
        private final String id;
        private final String role;

        @JsonCreator
        IdentifierWithRole(@JsonProperty(value="id") String id, @JsonProperty(value="role") String role) {
            this.id = Objects.requireNonNull(id, "id");
            this.role = Objects.requireNonNull(role, "role");
        }

        @JsonProperty
        public String id() {
            return this.id;
        }

        @JsonProperty
        public String role() {
            return this.role;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("role", (Object)this.role()).toString();
        }
    }

    static final class IdentifierWithPermissions {
        private final String id;
        private final Collection<Permission> permissions;

        @JsonCreator
        IdentifierWithPermissions(@JsonProperty(value="id") String id, @JsonProperty(value="permissions") Collection<Permission> permissions) {
            this.id = Objects.requireNonNull(id, "id");
            this.permissions = Objects.requireNonNull(permissions, "permissions");
        }

        @JsonProperty
        public String id() {
            return this.id;
        }

        @JsonProperty
        public Collection<Permission> permissions() {
            return this.permissions;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("permissions", this.permissions()).toString();
        }
    }
}

