/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.admin.auth.LegacyToken;
import com.linecorp.centraldogma.server.internal.storage.project.SafeProjectManager;
import com.linecorp.centraldogma.server.metadata.HolderWithRevision;
import com.linecorp.centraldogma.server.metadata.Member;
import com.linecorp.centraldogma.server.metadata.PerRolePermissions;
import com.linecorp.centraldogma.server.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.metadata.ProjectRole;
import com.linecorp.centraldogma.server.metadata.RepositoryMetadata;
import com.linecorp.centraldogma.server.metadata.RepositorySupport;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.TokenRegistration;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.metadata.UserAndTimestamp;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationUtil {
    private static final Logger logger = LoggerFactory.getLogger(MigrationUtil.class);
    static final String LEGACY_TOKEN_REPO = "tokens";
    static final String LEGACY_TOKEN_JSON = "/token.json";
    private static final TypeReference<Map<String, LegacyToken>> TOKEN_MAP_TYPE_REFERENCE = new TypeReference<Map<String, LegacyToken>>(){};
    private static final Author author = Author.SYSTEM;

    public static synchronized void migrate(ProjectManager projectManager, CommandExecutor executor) {
        Objects.requireNonNull(projectManager, "projectManager");
        Objects.requireNonNull(executor, "executor");
        RepositorySupport<ProjectMetadata> metadataRepo = new RepositorySupport<ProjectMetadata>(projectManager, executor, entry -> RepositorySupport.convertWithJackson(entry, ProjectMetadata.class));
        UserAndTimestamp userAndTimestamp = UserAndTimestamp.of(author);
        Entry<?> tokenEntry = ((Repository)((Project)projectManager.get("dogma")).repos().get("dogma")).getOrNull(Revision.HEAD, "/tokens.json").join();
        ImmutableSet migratedTokens = tokenEntry == null ? MigrationUtil.migrateTokens(projectManager, executor) : ImmutableSet.of();
        migratedTokens.forEach(token -> logger.info("Token '{}' has been migrated", (Object)token.id()));
        SafeProjectManager safeProjectManager = new SafeProjectManager(projectManager);
        safeProjectManager.list().values().forEach(p -> {
            block4: {
                if (MigrationUtil.alreadyMigrated(p)) {
                    return;
                }
                if (!p.repos().exists("meta")) {
                    return;
                }
                try {
                    ProjectMetadata metadata = (ProjectMetadata)metadataRepo.fetch(p.name(), "meta", "/metadata.json").join().object();
                    metadata.repos().put("meta", new RepositoryMetadata("meta", userAndTimestamp, PerRolePermissions.ofPublic()));
                    MigrationUtil.commitProjectMetadata(metadataRepo, executor, p.name(), metadata);
                    metadataRepo.push(p.name(), "meta", author, "Remove the old metadata file", Change.ofRemoval((String)"/metadata.json")).join();
                }
                catch (Throwable cause) {
                    cause = Exceptions.peel((Throwable)cause);
                    if (cause instanceof EntryNotFoundException) break block4;
                    Exceptions.throwUnsafely((Throwable)cause);
                }
            }
        });
        UserAndTimestamp creationTime = UserAndTimestamp.of(author);
        Map registrations = migratedTokens.stream().map(t -> new TokenRegistration(t.id(), ProjectRole.MEMBER, creationTime)).collect(Collectors.toMap(TokenRegistration::id, Function.identity()));
        safeProjectManager.list().values().forEach(p -> {
            if (MigrationUtil.alreadyMigrated(p)) {
                return;
            }
            Map<String, RepositoryMetadata> repos = p.repos().list().values().stream().filter(r -> !r.name().equals("dogma")).map(r -> new RepositoryMetadata(r.name(), userAndTimestamp, PerRolePermissions.ofPublic())).collect(Collectors.toMap(RepositoryMetadata::name, Function.identity()));
            ProjectMetadata metadata = new ProjectMetadata(p.name(), repos, (Map<String, Member>)ImmutableMap.of(), registrations, userAndTimestamp, null);
            MigrationUtil.commitProjectMetadata(metadataRepo, executor, p.name(), metadata);
        });
    }

    private static boolean alreadyMigrated(Project project) {
        try {
            Repository internalRepo = (Repository)project.repos().get("dogma");
            return internalRepo != null && internalRepo.getOrNull(Revision.HEAD, "/metadata.json").join() != null;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static void commitProjectMetadata(RepositorySupport<ProjectMetadata> metadataRepo, CommandExecutor executor, String projectName, ProjectMetadata metadata) {
        block5: {
            block4: {
                try {
                    executor.execute(Command.createRepository(author, projectName, "dogma")).join();
                }
                catch (Throwable cause) {
                    cause = Exceptions.peel((Throwable)cause);
                    if (cause instanceof RepositoryExistsException) break block4;
                    Exceptions.throwUnsafely((Throwable)cause);
                }
            }
            try {
                metadataRepo.push(projectName, "dogma", author, "Add the metadata file", Change.ofJsonUpsert((String)"/metadata.json", (JsonNode)Jackson.valueToTree((Object)metadata))).toCompletableFuture().join();
                logger.info("Project '{}' has been migrated", (Object)projectName);
            }
            catch (Throwable cause) {
                cause = Exceptions.peel((Throwable)cause);
                if (cause instanceof RedundantChangeException) break block5;
                Exceptions.throwUnsafely((Throwable)cause);
            }
        }
    }

    private static Collection<Token> migrateTokens(ProjectManager projectManager, CommandExecutor executor) {
        boolean success;
        Tokens tokens;
        Runnable successCallback;
        block15: {
            Project project;
            RepositorySupport<Tokens> tokensRepo;
            block13: {
                tokensRepo = new RepositorySupport<Tokens>(projectManager, executor, entry -> RepositorySupport.convertWithJackson(entry, Tokens.class));
                project = (Project)projectManager.get("dogma");
                successCallback = null;
                tokens = null;
                if (project.repos().exists("main")) {
                    try {
                        tokens = (Tokens)((CompletableFuture)tokensRepo.fetch("dogma", "main", "/tokens.json").thenApply(HolderWithRevision::object)).join();
                        successCallback = () -> tokensRepo.push("dogma", "main", author, "Remove the old token list file", Change.ofRemoval((String)"/tokens.json")).join();
                    }
                    catch (Throwable cause) {
                        cause = Exceptions.peel((Throwable)cause);
                        if (cause instanceof EntryNotFoundException) break block13;
                        Exceptions.throwUnsafely((Throwable)cause);
                    }
                }
            }
            if (tokens == null) {
                Object legacyTokens;
                block14: {
                    legacyTokens = null;
                    if (project.repos().exists(LEGACY_TOKEN_REPO)) {
                        try {
                            legacyTokens = (Collection)((CompletableFuture)((Repository)project.repos().get(LEGACY_TOKEN_REPO)).getOrNull(Revision.HEAD, LEGACY_TOKEN_JSON).thenApply(entry -> {
                                if (entry != null) {
                                    return ((Map)Jackson.convertValue((Object)entry.content(), TOKEN_MAP_TYPE_REFERENCE)).values();
                                }
                                return ImmutableList.of();
                            })).join();
                            successCallback = () -> tokensRepo.push("dogma", LEGACY_TOKEN_REPO, author, "Remove the old token list file", Change.ofRemoval((String)LEGACY_TOKEN_JSON)).join();
                        }
                        catch (Throwable cause) {
                            cause = Exceptions.peel((Throwable)cause);
                            if (cause instanceof EntryNotFoundException) break block14;
                            Exceptions.throwUnsafely((Throwable)cause);
                        }
                    }
                }
                if (legacyTokens == null) {
                    legacyTokens = ImmutableList.of();
                }
                Map<String, Token> tokenMap = legacyTokens.stream().map(MigrationUtil::migrateToken).collect(Collectors.toMap(Token::id, Function.identity()));
                Map<String, String> secretMap = tokenMap.values().stream().collect(Collectors.toMap(Token::secret, Token::id));
                tokens = new Tokens(tokenMap, secretMap);
            }
            success = false;
            try {
                Change change = Change.ofJsonUpsert((String)"/tokens.json", (JsonNode)Jackson.valueToTree(tokens));
                tokensRepo.push("dogma", "dogma", author, "Add the token list file", change).toCompletableFuture().join();
                success = true;
            }
            catch (Throwable cause) {
                cause = Exceptions.peel((Throwable)cause);
                if (cause instanceof RedundantChangeException) break block15;
                Exceptions.throwUnsafely((Throwable)cause);
            }
        }
        try {
            if (success && successCallback != null) {
                successCallback.run();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tokens.appIds().values();
    }

    private static Token migrateToken(LegacyToken legacyToken) {
        return new Token(legacyToken.appId(), legacyToken.secret(), false, new UserAndTimestamp(legacyToken.creator().email(), legacyToken.creationTime()));
    }

    private MigrationUtil() {
    }
}

