/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.EntryNoContentException;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.internal.admin.service.TokenNotFoundException;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.storage.RequestAlreadyTimedOutException;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryMetadataException;
import java.util.Map;

public final class HttpApiExceptionHandler
implements ExceptionHandlerFunction {
    private static final Map<Class<?>, ExceptionHandlerFunction> exceptionHandlers;

    public HttpResponse handleException(ServiceRequestContext ctx, HttpRequest req, Throwable cause) {
        if (cause instanceof HttpStatusException || cause instanceof HttpResponseException) {
            return (HttpResponse)ExceptionHandlerFunction.fallthrough();
        }
        ExceptionHandlerFunction func = exceptionHandlers.get(cause.getClass());
        if (func != null) {
            return func.handleException(ctx, req, cause);
        }
        if (cause instanceof IllegalArgumentException) {
            return HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.BAD_REQUEST, cause);
        }
        if (cause instanceof RequestAlreadyTimedOutException) {
            return HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.SERVICE_UNAVAILABLE, cause);
        }
        return HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.INTERNAL_SERVER_ERROR, cause);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ChangeConflictException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.CONFLICT, cause, "The given changeset or revision has a conflict.")).put(EntryNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.NOT_FOUND, cause, "Entry '%s' does not exist.", cause.getMessage())).put(EntryNoContentException.class, (ctx, req, cause) -> HttpResponse.of((HttpStatus)HttpStatus.NO_CONTENT)).put(ProjectExistsException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.CONFLICT, cause, "Project '%s' exists already.", cause.getMessage())).put(ProjectNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.NOT_FOUND, cause, "Project '%s' does not exist.", cause.getMessage())).put(RedundantChangeException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.CONFLICT, cause, "The given changeset does not change anything.")).put(RepositoryExistsException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.CONFLICT, cause, "Repository '%s' exists already.", cause.getMessage())).put(RepositoryMetadataException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.INTERNAL_SERVER_ERROR, cause)).put(RepositoryNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.NOT_FOUND, cause, "Repository '%s' does not exist.", cause.getMessage())).put(RevisionNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.NOT_FOUND, cause, "Revision %s does not exist.", cause.getMessage())).put(TokenNotFoundException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.NOT_FOUND, cause, "Token '%s' does not exist.", cause.getMessage())).put(QueryExecutionException.class, (ctx, req, cause) -> HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.BAD_REQUEST, cause));
        exceptionHandlers = builder.build();
    }
}

