/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.SessionManager;
import com.linecorp.centraldogma.server.command.AbstractCommandExecutor;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.command.CreateProjectCommand;
import com.linecorp.centraldogma.server.command.CreateRepositoryCommand;
import com.linecorp.centraldogma.server.command.CreateSessionCommand;
import com.linecorp.centraldogma.server.command.PurgeProjectCommand;
import com.linecorp.centraldogma.server.command.PurgeRepositoryCommand;
import com.linecorp.centraldogma.server.command.PushCommand;
import com.linecorp.centraldogma.server.command.RemoveProjectCommand;
import com.linecorp.centraldogma.server.command.RemoveRepositoryCommand;
import com.linecorp.centraldogma.server.command.RemoveSessionCommand;
import com.linecorp.centraldogma.server.command.RepositoryCommand;
import com.linecorp.centraldogma.server.command.UnremoveProjectCommand;
import com.linecorp.centraldogma.server.command.UnremoveRepositoryCommand;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneCommandExecutor
extends AbstractCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneCommandExecutor.class);
    private final ProjectManager projectManager;
    private final Executor repositoryWorker;
    @Nullable
    private final SessionManager sessionManager;

    public StandaloneCommandExecutor(ProjectManager projectManager, Executor repositoryWorker, @Nullable SessionManager sessionManager, @Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Consumer<CommandExecutor> onReleaseLeadership) {
        super(onTakeLeadership, onReleaseLeadership);
        this.projectManager = Objects.requireNonNull(projectManager, "projectManager");
        this.repositoryWorker = Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        this.sessionManager = sessionManager;
    }

    @Override
    public int replicaId() {
        return 0;
    }

    @Override
    protected void doStart(@Nullable Runnable onTakeLeadership, @Nullable Runnable onReleaseLeadership) {
        if (onTakeLeadership != null) {
            onTakeLeadership.run();
        }
    }

    @Override
    protected void doStop(@Nullable Runnable onReleaseLeadership) {
        if (onReleaseLeadership != null) {
            onReleaseLeadership.run();
        }
    }

    @Override
    protected <T> CompletableFuture<T> doExecute(Command<T> command) throws Exception {
        if (command instanceof CreateProjectCommand) {
            return this.createProject((CreateProjectCommand)command);
        }
        if (command instanceof RemoveProjectCommand) {
            return this.removeProject((RemoveProjectCommand)command);
        }
        if (command instanceof UnremoveProjectCommand) {
            return this.unremoveProject((UnremoveProjectCommand)command);
        }
        if (command instanceof PurgeProjectCommand) {
            return this.purgeProject((PurgeProjectCommand)command);
        }
        if (command instanceof CreateRepositoryCommand) {
            return this.createRepository((CreateRepositoryCommand)command);
        }
        if (command instanceof RemoveRepositoryCommand) {
            return this.removeRepository((RemoveRepositoryCommand)command);
        }
        if (command instanceof UnremoveRepositoryCommand) {
            return this.unremoveRepository((UnremoveRepositoryCommand)command);
        }
        if (command instanceof PurgeRepositoryCommand) {
            return this.purgeRepository((PurgeRepositoryCommand)command);
        }
        if (command instanceof PushCommand) {
            return this.push((PushCommand)command);
        }
        if (command instanceof CreateSessionCommand) {
            return this.createSession((CreateSessionCommand)command);
        }
        if (command instanceof RemoveSessionCommand) {
            return this.removeSession((RemoveSessionCommand)command);
        }
        throw new UnsupportedOperationException(command.toString());
    }

    private CompletableFuture<Void> createProject(CreateProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.create(c.projectName(), c.timestamp(), c.author());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeProject(RemoveProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.remove(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> unremoveProject(UnremoveProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.unremove(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> purgeProject(PurgeProjectCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            this.projectManager.markForPurge(c.projectName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> createRepository(CreateRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().create(c.repositoryName(), c.timestamp(), c.author());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> removeRepository(RemoveRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().remove(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> unremoveRepository(UnremoveRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().unremove(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Void> purgeRepository(PurgeRepositoryCommand c) {
        return CompletableFuture.supplyAsync(() -> {
            ((Project)this.projectManager.get(c.projectName())).repos().markForPurge(c.repositoryName());
            return null;
        }, this.repositoryWorker);
    }

    private CompletableFuture<Revision> push(PushCommand c) {
        return this.repo(c).commit(c.baseRevision(), c.timestamp(), c.author(), c.summary(), c.detail(), c.markup(), c.changes());
    }

    private Repository repo(RepositoryCommand<?> c) {
        return (Repository)((Project)this.projectManager.get(c.projectName())).repos().get(c.repositoryName());
    }

    private CompletableFuture<Void> createSession(CreateSessionCommand c) {
        if (this.sessionManager == null) {
            return CompletableFuture.completedFuture(null);
        }
        Session session = c.session();
        return this.sessionManager.create(session).exceptionally(cause -> {
            logger.warn("Failed to replicate a session creation: {}", (Object)session, cause);
            return null;
        });
    }

    private CompletableFuture<Void> removeSession(RemoveSessionCommand c) {
        if (this.sessionManager == null) {
            return CompletableFuture.completedFuture(null);
        }
        String sessionId = c.sessionId();
        return this.sessionManager.delete(sessionId).exceptionally(cause -> {
            logger.warn("Failed to replicate a session removal: {}", (Object)sessionId, cause);
            return null;
        });
    }
}

