/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.centraldogma.server.ReplicationConfig;
import com.linecorp.centraldogma.server.ReplicationMethod;
import com.linecorp.centraldogma.server.ZooKeeperAddress;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class ZooKeeperReplicationConfig
implements ReplicationConfig {
    private static final int DEFAULT_TIMEOUT_MILLIS = 10000;
    private static final int DEFAULT_NUM_WORKERS = 16;
    private static final int DEFAULT_MAX_LOG_COUNT = 1024;
    private static final long DEFAULT_MIN_LOG_AGE_MILLIS = TimeUnit.DAYS.toMillis(1L);
    private static final String DEFAULT_SECRET = "ch4n63m3";
    private final int serverId;
    private final Map<Integer, ZooKeeperAddress> servers;
    private final String secret;
    private final Map<String, String> additionalProperties;
    private final int timeoutMillis;
    private final int numWorkers;
    private final int maxLogCount;
    private final long minLogAgeMillis;

    public ZooKeeperReplicationConfig(int serverId, Map<Integer, ZooKeeperAddress> servers) {
        this((Integer)serverId, servers, null, null, null, null, null, null);
    }

    @VisibleForTesting
    ZooKeeperReplicationConfig(int serverId, Map<Integer, ZooKeeperAddress> servers, String secret, Map<String, String> additionalProperties, int timeoutMillis, int numWorkers, int maxLogCount, long minLogAgeMillis) {
        this((Integer)serverId, servers, secret, additionalProperties, (Integer)timeoutMillis, (Integer)numWorkers, (Integer)maxLogCount, (Long)minLogAgeMillis);
    }

    @JsonCreator
    ZooKeeperReplicationConfig(@JsonProperty(value="serverId") @Nullable Integer serverId, @JsonProperty(value="servers", required=true) @JsonDeserialize(keyAs=Integer.class, contentAs=ZooKeeperAddress.class) Map<Integer, ZooKeeperAddress> servers, @JsonProperty(value="secret") @Nullable String secret, @JsonProperty(value="additionalProperties") @JsonDeserialize(keyAs=String.class, contentAs=String.class) @Nullable Map<String, String> additionalProperties, @JsonProperty(value="timeoutMillis") @Nullable Integer timeoutMillis, @JsonProperty(value="numWorkers") @Nullable Integer numWorkers, @JsonProperty(value="maxLogCount") @Nullable Integer maxLogCount, @JsonProperty(value="minLogAgeMillis") @Nullable Long minLogAgeMillis) {
        Objects.requireNonNull(servers, "servers");
        this.serverId = serverId != null ? serverId : ZooKeeperReplicationConfig.findServerId(servers);
        Preconditions.checkArgument((this.serverId > 0 ? 1 : 0) != 0, (String)"serverId: %s (expected: > 0)", (Object)serverId);
        this.secret = (String)MoreObjects.firstNonNull((Object)secret, (Object)DEFAULT_SECRET);
        Preconditions.checkArgument((!this.secret.isEmpty() ? 1 : 0) != 0, (Object)"secret is empty.");
        servers.forEach((id, server) -> Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (String)"'servers' contains non-positive server ID: %s (expected: > 0)", (Object)id));
        this.servers = ImmutableMap.copyOf(servers);
        Preconditions.checkArgument((!this.servers.isEmpty() ? 1 : 0) != 0, (Object)"servers is empty.");
        Preconditions.checkArgument((boolean)this.servers.containsKey(this.serverId), (String)"servers must contain the server '%s'.", (int)this.serverId);
        this.additionalProperties = (Map)MoreObjects.firstNonNull(additionalProperties, (Object)ImmutableMap.of());
        this.timeoutMillis = timeoutMillis == null || timeoutMillis <= 0 ? 10000 : timeoutMillis;
        this.numWorkers = numWorkers == null || numWorkers <= 0 ? 16 : numWorkers;
        this.maxLogCount = maxLogCount == null || maxLogCount <= 0 ? 1024 : maxLogCount;
        this.minLogAgeMillis = minLogAgeMillis == null || minLogAgeMillis <= 0L ? DEFAULT_MIN_LOG_AGE_MILLIS : minLogAgeMillis;
    }

    private static int findServerId(Map<Integer, ZooKeeperAddress> servers) {
        int serverId = -1;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                serverId = ZooKeeperReplicationConfig.findServerId(servers, serverId, e.nextElement());
            }
        }
        catch (SocketException e) {
            throw new IllegalStateException("failed to retrieve the network interface list", e);
        }
        if (serverId < 0) {
            throw new IllegalStateException("failed to auto-detect server ID because there is no matching IP address.");
        }
        return serverId;
    }

    private static int findServerId(Map<Integer, ZooKeeperAddress> servers, int currentServerId, NetworkInterface iface) {
        Enumeration<InetAddress> ea = iface.getInetAddresses();
        while (ea.hasMoreElements()) {
            currentServerId = ZooKeeperReplicationConfig.findServerId(servers, currentServerId, ea.nextElement());
        }
        return currentServerId;
    }

    private static int findServerId(Map<Integer, ZooKeeperAddress> servers, int currentServerId, InetAddress addr) {
        String ip = NetUtil.toAddressString((InetAddress)addr, (boolean)true);
        for (Map.Entry<Integer, ZooKeeperAddress> entry : servers.entrySet()) {
            String zkAddr;
            try {
                zkAddr = NetUtil.toAddressString((InetAddress)InetAddress.getByName(entry.getValue().host()), (boolean)true);
            }
            catch (UnknownHostException uhe) {
                throw new IllegalStateException("failed to resolve the IP address of the server name: " + entry.getValue().host());
            }
            if (!zkAddr.equals(ip)) continue;
            int serverId = entry.getKey();
            if (currentServerId < 0) {
                currentServerId = serverId;
                continue;
            }
            if (currentServerId == serverId) continue;
            throw new IllegalStateException("cannot auto-detect server ID because there are more than one IP address match. Both server ID " + currentServerId + " and " + serverId + " have a matching IP address. Consider specifying server ID explicitly.");
        }
        return currentServerId;
    }

    @Override
    public ReplicationMethod method() {
        return ReplicationMethod.ZOOKEEPER;
    }

    @JsonProperty
    public int serverId() {
        return this.serverId;
    }

    public ZooKeeperAddress serverAddress() {
        return this.servers.get(this.serverId);
    }

    @JsonProperty
    public Map<Integer, ZooKeeperAddress> servers() {
        return this.servers;
    }

    public String secret() {
        return this.secret;
    }

    @JsonProperty
    public Map<String, String> additionalProperties() {
        return this.additionalProperties;
    }

    @JsonProperty
    public int timeoutMillis() {
        return this.timeoutMillis;
    }

    @JsonProperty
    public int numWorkers() {
        return this.numWorkers;
    }

    @JsonProperty
    public int maxLogCount() {
        return this.maxLogCount;
    }

    @JsonProperty
    public long minLogAgeMillis() {
        return this.minLogAgeMillis;
    }

    public int hashCode() {
        return this.serverId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZooKeeperReplicationConfig)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ZooKeeperReplicationConfig that = (ZooKeeperReplicationConfig)obj;
        return this.serverId() == that.serverId() && this.servers().equals(that.servers()) && this.additionalProperties().equals(that.additionalProperties()) && this.timeoutMillis() == that.timeoutMillis() && this.numWorkers() == that.numWorkers() && this.maxLogCount() == that.maxLogCount() && this.minLogAgeMillis() == that.minLogAgeMillis();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serverId", this.serverId()).add("servers", this.servers()).add("additionalProperties", this.additionalProperties()).add("timeoutMillis", this.timeoutMillis()).add("numWorkers", this.numWorkers()).add("maxLogCount", this.maxLogCount()).add("minLogAgeMillis", this.minLogAgeMillis()).toString();
    }
}

