/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.CacheableCall;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

final class CacheableHistoryCall
extends CacheableCall<List<Commit>> {
    final Revision from;
    final Revision to;
    final String pathPattern;
    final int maxCommits;
    final int hashCode;

    CacheableHistoryCall(Repository repo, Revision from, Revision to, String pathPattern, int maxCommits) {
        super(repo);
        this.from = Objects.requireNonNull(from, "from");
        this.to = Objects.requireNonNull(to, "to");
        this.pathPattern = Objects.requireNonNull(pathPattern, "pathPattern");
        this.maxCommits = maxCommits;
        this.hashCode = (Objects.hash(from, to, pathPattern) * 31 + maxCommits) * 31 + System.identityHashCode(repo);
        assert (!from.isRelative());
        assert (!to.isRelative());
    }

    @Override
    protected int weigh(List<Commit> value) {
        int weight = 0;
        weight += this.pathPattern.length();
        for (Commit c : value) {
            weight += c.author().name().length() + c.author().email().length() + c.summary().length() + c.detail().length();
        }
        return weight;
    }

    @Override
    public CompletableFuture<List<Commit>> execute() {
        return this.repo().history(this.from, this.to, this.pathPattern, this.maxCommits);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableHistoryCall that = (CacheableHistoryCall)o;
        return this.from.equals((Object)that.from) && this.to.equals((Object)that.to) && this.pathPattern.equals(that.pathPattern) && this.maxCommits == that.maxCommits;
    }

    @Override
    protected void toString(MoreObjects.ToStringHelper helper) {
        helper.add("from", (Object)this.from).add("to", (Object)this.to).add("pathPattern", (Object)this.pathPattern).add("maxCommits", this.maxCommits);
    }
}

