/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.replication;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.TimeGauge;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.zookeeper.server.PurgeTxnLog;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EmbeddedZooKeeper
extends QuorumPeer {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedZooKeeper.class);
    static final String SASL_SERVER_LOGIN_CONTEXT = "QuorumServer";
    static final String SASL_LEARNER_LOGIN_CONTEXT = "QuorumLearner";
    private static final ServerStats EMPTY_STATS = new InactiveServerStats();
    private final ServerCnxnFactory cnxnFactory;
    private final DatadirCleanupManager purgeManager;

    EmbeddedZooKeeper(QuorumPeerConfig zkCfg, MeterRegistry meterRegistry) throws IOException {
        this.cnxnFactory = EmbeddedZooKeeper.createCnxnFactory(zkCfg);
        this.setTxnFactory(new FileTxnSnapLog(zkCfg.getDataLogDir(), zkCfg.getDataDir()));
        this.enableLocalSessions(zkCfg.areLocalSessionsEnabled());
        this.enableLocalSessionsUpgrading(zkCfg.isLocalSessionsUpgradingEnabled());
        this.setElectionType(zkCfg.getElectionAlg());
        this.setMyid(zkCfg.getServerId());
        this.setTickTime(zkCfg.getTickTime());
        this.setMinSessionTimeout(zkCfg.getMinSessionTimeout());
        this.setMaxSessionTimeout(zkCfg.getMaxSessionTimeout());
        this.setInitLimit(zkCfg.getInitLimit());
        this.setSyncLimit(zkCfg.getSyncLimit());
        this.setConfigFileName(zkCfg.getConfigFilename());
        this.setZKDatabase(new ZKDatabase(this.getTxnFactory()));
        this.setQuorumVerifier(zkCfg.getQuorumVerifier(), false);
        if (zkCfg.getLastSeenQuorumVerifier() != null) {
            this.setLastSeenQuorumVerifier(zkCfg.getLastSeenQuorumVerifier(), false);
        }
        this.initConfigInZKDatabase();
        this.setCnxnFactory(this.cnxnFactory);
        this.setLearnerType(zkCfg.getPeerType());
        this.setSyncEnabled(zkCfg.getSyncEnabled());
        this.setQuorumListenOnAllIPs(zkCfg.getQuorumListenOnAllIPs());
        this.configureSasl();
        this.purgeManager = new DatadirCleanupManager(zkCfg.getDataDir(), zkCfg.getDataLogDir(), zkCfg.getSnapRetainCount(), zkCfg.getPurgeInterval());
        TimeGauge.builder((String)"replica.zk.latency", (Object)((Object)this), (TimeUnit)TimeUnit.MILLISECONDS, self -> EmbeddedZooKeeper.serverStats(self).getAvgLatency()).tag("type", "avg").register(meterRegistry);
        TimeGauge.builder((String)"replica.zk.latency", (Object)((Object)this), (TimeUnit)TimeUnit.MILLISECONDS, self -> EmbeddedZooKeeper.serverStats(self).getMaxLatency()).tag("type", "max").register(meterRegistry);
        TimeGauge.builder((String)"replica.zk.latency", (Object)((Object)this), (TimeUnit)TimeUnit.MILLISECONDS, self -> EmbeddedZooKeeper.serverStats(self).getMinLatency()).tag("type", "min").register(meterRegistry);
        Gauge.builder((String)"replica.zk.outstandingRequests", (Object)((Object)this), self -> EmbeddedZooKeeper.serverStats(self).getOutstandingRequests()).register(meterRegistry);
        Gauge.builder((String)"replica.zk.lastProcessedZxid", (Object)((Object)this), self -> EmbeddedZooKeeper.serverStats(self).getLastProcessedZxid()).register(meterRegistry);
        Gauge.builder((String)"replica.zk.dataDirSize", (Object)((Object)this), self -> EmbeddedZooKeeper.serverStats(self).getDataDirSize()).baseUnit("bytes").register(meterRegistry);
        Gauge.builder((String)"replica.zk.logDirSize", (Object)((Object)this), self -> EmbeddedZooKeeper.serverStats(self).getLogDirSize()).baseUnit("bytes").register(meterRegistry);
        FunctionCounter.builder((String)"replica.zk.packetsReceived", (Object)((Object)this), self -> EmbeddedZooKeeper.serverStats(self).getPacketsReceived()).register(meterRegistry);
        FunctionCounter.builder((String)"replica.zk.packetsSent", (Object)((Object)this), self -> EmbeddedZooKeeper.serverStats(self).getPacketsSent()).register(meterRegistry);
        Gauge.builder((String)"replica.zk.aliveClientConnections", (Object)((Object)this), self -> EmbeddedZooKeeper.serverStats(self).getNumAliveClientConnections()).register(meterRegistry);
        Gauge.builder((String)"replica.zk.state", (Object)((Object)this), self -> {
            String state = EmbeddedZooKeeper.serverStats(self).getServerState();
            if (state == null) {
                return 0.0;
            }
            switch (state) {
                case "leader": {
                    return 1.0;
                }
                case "follower": {
                    return 2.0;
                }
                case "observer": {
                    return 3.0;
                }
                case "read-only": {
                    return 4.0;
                }
            }
            return 5.0;
        }).description("0 = inactive, 1 = leader, 2 = follower, 3 = observer, 4 = read-only, 5 = unknown").register(meterRegistry);
        Gauge.builder((String)"replica.zk.approximateDataSize", (Object)((Object)this), (ToDoubleFunction)new ApproximateDataSizeFunction()).baseUnit("bytes").register(meterRegistry);
        Gauge.builder((String)"replica.zk.nodes", (Object)((Object)this), self -> {
            DataTree tree = EmbeddedZooKeeper.dataTree(self);
            return tree != null ? (double)tree.getNodeCount() : 0.0;
        }).register(meterRegistry);
        Gauge.builder((String)"replica.zk.ephemerals", (Object)((Object)this), self -> {
            DataTree tree = EmbeddedZooKeeper.dataTree(self);
            return tree != null ? (double)tree.getEphemeralsCount() : 0.0;
        }).register(meterRegistry);
        Gauge.builder((String)"replica.zk.watches", (Object)((Object)this), self -> {
            DataTree tree = EmbeddedZooKeeper.dataTree(self);
            return tree != null ? (double)tree.getWatchCount() : 0.0;
        }).register(meterRegistry);
    }

    private static ServerStats serverStats(@Nullable EmbeddedZooKeeper peer) {
        if (peer == null) {
            return EMPTY_STATS;
        }
        ZooKeeperServer activeServer = peer.getActiveServer();
        if (activeServer == null) {
            return EMPTY_STATS;
        }
        ServerStats stats = activeServer.serverStats();
        return (ServerStats)MoreObjects.firstNonNull((Object)stats, (Object)EMPTY_STATS);
    }

    @Nullable
    private static DataTree dataTree(@Nullable EmbeddedZooKeeper peer) {
        if (peer == null) {
            return null;
        }
        ZooKeeperServer activeServer = peer.getActiveServer();
        if (activeServer == null) {
            return null;
        }
        ZKDatabase database = activeServer.getZKDatabase();
        if (database == null) {
            return null;
        }
        return database.getDataTree();
    }

    private static ServerCnxnFactory createCnxnFactory(QuorumPeerConfig zkCfg) throws IOException {
        InetSocketAddress bindAddr = zkCfg.getClientPortAddress();
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        cnxnFactory.configure(new InetSocketAddress("127.0.0.1", bindAddr != null ? bindAddr.getPort() : 0), zkCfg.getMaxClientCnxns());
        return cnxnFactory;
    }

    private void configureSasl() {
        this.quorumServerSaslAuthRequired = true;
        this.quorumLearnerSaslAuthRequired = true;
        this.quorumServerLoginContext = SASL_SERVER_LOGIN_CONTEXT;
        this.quorumLearnerLoginContext = SASL_LEARNER_LOGIN_CONTEXT;
    }

    public synchronized void start() {
        this.purgeTxnLogs();
        this.purgeManager.start();
        super.start();
    }

    public void shutdown() {
        this.cnxnFactory.shutdown();
        this.purgeManager.shutdown();
        super.shutdown();
    }

    private void purgeTxnLogs() {
        logger.info("Purging old ZooKeeper snapshots and logs ..");
        try {
            PurgeTxnLog.purge((File)this.purgeManager.getDataLogDir(), (File)this.purgeManager.getSnapDir(), (int)this.purgeManager.getSnapRetainCount());
            logger.info("Purged old ZooKeeper snapshots and logs.");
        }
        catch (IOException e) {
            logger.error("Failed to purge old ZooKeeper snapshots and logs:", (Throwable)e);
        }
    }

    private static class ApproximateDataSizeFunction
    implements ToDoubleFunction<EmbeddedZooKeeper> {
        private static final long MIN_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(3L);
        private volatile long lastCalculationTimeNanos = System.nanoTime() - MIN_INTERVAL_NANOS;
        private long value;

        private ApproximateDataSizeFunction() {
        }

        @Override
        public double applyAsDouble(EmbeddedZooKeeper self) {
            long value;
            long currentTimeNanos = System.nanoTime();
            if (currentTimeNanos - this.lastCalculationTimeNanos < MIN_INTERVAL_NANOS) {
                return this.value;
            }
            DataTree tree = EmbeddedZooKeeper.dataTree(self);
            this.value = value = tree != null ? tree.approximateDataSize() : 0L;
            this.lastCalculationTimeNanos = currentTimeNanos;
            return value;
        }
    }

    private static final class InactiveServerStats
    extends ServerStats {
        InactiveServerStats() {
            super(new ServerStats.Provider(){

                public long getOutstandingRequests() {
                    return 0L;
                }

                public long getLastProcessedZxid() {
                    return 0L;
                }

                @Nullable
                public String getState() {
                    return null;
                }

                public int getNumAliveConnections() {
                    return 0;
                }

                public long getDataDirSize() {
                    return 0L;
                }

                public long getLogDirSize() {
                    return 0L;
                }
            });
        }
    }
}

