/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.shaded.cronutils.descriptor.CronDescriptor;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.Cron;
import com.linecorp.centraldogma.internal.shaded.cronutils.model.time.ExecutionTime;
import com.linecorp.centraldogma.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import com.linecorp.centraldogma.server.mirror.Mirror;
import com.linecorp.centraldogma.server.mirror.MirrorCredential;
import com.linecorp.centraldogma.server.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.mirror.MirrorUtil;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.io.File;
import java.net.URI;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class AbstractMirror
implements Mirror {
    protected static final Author MIRROR_AUTHOR = new Author("Mirror", "mirror@localhost.localdomain");
    private final Cron schedule;
    private final MirrorDirection direction;
    private final MirrorCredential credential;
    private final Repository localRepo;
    private final String localPath;
    private final URI remoteRepoUri;
    private final String remotePath;
    private final String remoteBranch;
    private final ExecutionTime executionTime;
    private final long jitterMillis;

    protected AbstractMirror(Cron schedule, MirrorDirection direction, MirrorCredential credential, Repository localRepo, String localPath, URI remoteRepoUri, String remotePath, @Nullable String remoteBranch) {
        this.schedule = Objects.requireNonNull(schedule, "schedule");
        this.direction = Objects.requireNonNull(direction, "direction");
        this.credential = Objects.requireNonNull(credential, "credential");
        this.localRepo = Objects.requireNonNull(localRepo, "localRepo");
        this.localPath = MirrorUtil.normalizePath(Objects.requireNonNull(localPath, "localPath"));
        this.remoteRepoUri = Objects.requireNonNull(remoteRepoUri, "remoteRepoUri");
        this.remotePath = MirrorUtil.normalizePath(Objects.requireNonNull(remotePath, "remotePath"));
        this.remoteBranch = remoteBranch;
        this.executionTime = ExecutionTime.forCron((Cron)this.schedule);
        this.jitterMillis = Math.abs(Objects.hash(new Object[]{this.schedule.asString(), this.direction, this.localRepo.parent().name(), this.localRepo.name(), this.remoteRepoUri, this.remotePath, this.remoteBranch}) / 35791);
    }

    @Override
    public final Cron schedule() {
        return this.schedule;
    }

    @Override
    public final ZonedDateTime nextExecutionTime(ZonedDateTime lastExecutionTime) {
        return this.nextExecutionTime(lastExecutionTime, this.jitterMillis);
    }

    @VisibleForTesting
    ZonedDateTime nextExecutionTime(ZonedDateTime lastExecutionTime, long jitterMillis) {
        Objects.requireNonNull(lastExecutionTime, "lastExecutionTime");
        ZonedDateTime next = this.executionTime.nextExecution(lastExecutionTime.minus(jitterMillis, ChronoUnit.MILLIS));
        return next.plus(jitterMillis, ChronoUnit.MILLIS);
    }

    @Override
    public MirrorDirection direction() {
        return this.direction;
    }

    @Override
    public final MirrorCredential credential() {
        return this.credential;
    }

    @Override
    public final Repository localRepo() {
        return this.localRepo;
    }

    @Override
    public final String localPath() {
        return this.localPath;
    }

    @Override
    public final URI remoteRepoUri() {
        return this.remoteRepoUri;
    }

    @Override
    public final String remotePath() {
        return this.remotePath;
    }

    @Override
    public final String remoteBranch() {
        return this.remoteBranch;
    }

    @Override
    public final void mirror(File workDir, CommandExecutor executor, int maxNumFiles, long maxNumBytes) {
        try {
            switch (this.direction()) {
                case LOCAL_TO_REMOTE: {
                    this.mirrorLocalToRemote(workDir, maxNumFiles, maxNumBytes);
                    break;
                }
                case REMOTE_TO_LOCAL: {
                    this.mirrorRemoteToLocal(workDir, executor, maxNumFiles, maxNumBytes);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (MirrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MirrorException(e);
        }
    }

    protected abstract void mirrorLocalToRemote(File var1, int var2, long var3) throws Exception;

    protected abstract void mirrorRemoteToLocal(File var1, CommandExecutor var2, int var3, long var4) throws Exception;

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"").add("schedule", (Object)CronDescriptor.instance().describe(this.schedule)).add("direction", (Object)this.direction).add("localProj", (Object)this.localRepo.parent().name()).add("localRepo", (Object)this.localRepo.name()).add("localPath", (Object)this.localPath).add("remoteRepo", (Object)this.remoteRepoUri).add("remotePath", (Object)this.remotePath);
        if (this.remoteBranch != null) {
            helper.add("remoteBranch", (Object)this.remoteBranch);
        }
        helper.add("credential", (Object)this.credential);
        return helper.toString();
    }
}

