/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.StartStopSupport;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.server.command.Command;
import com.linecorp.centraldogma.server.command.CommandExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class AbstractCommandExecutor
implements CommandExecutor {
    @Nullable
    private final Consumer<CommandExecutor> onTakeLeadership;
    @Nullable
    private final Consumer<CommandExecutor> onReleaseLeadership;
    private final CommandExecutorStartStop startStop = new CommandExecutorStartStop();
    private volatile boolean started;
    private volatile boolean writable = true;
    private final AtomicInteger numPendingStopRequests = new AtomicInteger();

    protected AbstractCommandExecutor(@Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Consumer<CommandExecutor> onReleaseLeadership) {
        this.onTakeLeadership = onTakeLeadership;
        this.onReleaseLeadership = onReleaseLeadership;
    }

    @Override
    public final boolean isStarted() {
        return this.started;
    }

    protected final boolean isStopping() {
        return this.numPendingStopRequests.get() > 0;
    }

    @Override
    public final CompletableFuture<Void> start() {
        return this.startStop.start(false).thenRun(() -> {
            this.started = true;
        });
    }

    protected abstract void doStart(@Nullable Runnable var1, @Nullable Runnable var2) throws Exception;

    @Override
    public final CompletableFuture<Void> stop() {
        this.started = false;
        this.numPendingStopRequests.incrementAndGet();
        return this.startStop.stop().thenRun(this.numPendingStopRequests::decrementAndGet);
    }

    protected abstract void doStop(@Nullable Runnable var1) throws Exception;

    @Override
    public final boolean isWritable() {
        return this.isStarted() && this.writable;
    }

    @Override
    public final void setWritable(boolean writable) {
        this.writable = writable;
    }

    @Override
    public final <T> CompletableFuture<T> execute(Command<T> command) {
        Objects.requireNonNull(command, "command");
        if (!this.isWritable()) {
            throw new IllegalStateException("running in read-only mode");
        }
        try {
            return this.doExecute(command);
        }
        catch (Throwable t) {
            CompletableFuture f = new CompletableFuture();
            f.completeExceptionally(t);
            return f;
        }
    }

    protected abstract <T> CompletableFuture<T> doExecute(Command<T> var1) throws Exception;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writable", this.isWritable()).add("replicating", this.started).toString();
    }

    private final class CommandExecutorStartStop
    extends StartStopSupport<Void, Void, Void, Void> {
        CommandExecutorStartStop() {
            super((Executor)ForkJoinPool.commonPool());
        }

        protected CompletionStage<Void> doStart(@Nullable Void unused) throws Exception {
            return this.execute("command-executor", () -> {
                try {
                    AbstractCommandExecutor.this.doStart(this.toRunnable(AbstractCommandExecutor.this.onTakeLeadership), this.toRunnable(AbstractCommandExecutor.this.onReleaseLeadership));
                }
                catch (Exception e) {
                    Exceptions.throwUnsafely((Throwable)e);
                }
            });
        }

        protected CompletionStage<Void> doStop(@Nullable Void unused) throws Exception {
            return this.execute("command-executor-shutdown", () -> {
                try {
                    AbstractCommandExecutor.this.doStop(this.toRunnable(AbstractCommandExecutor.this.onReleaseLeadership));
                }
                catch (Exception e) {
                    Exceptions.throwUnsafely((Throwable)e);
                }
            });
        }

        @Nullable
        private Runnable toRunnable(@Nullable Consumer<CommandExecutor> callback) {
            return callback != null ? () -> callback.accept(AbstractCommandExecutor.this) : null;
        }

        private CompletionStage<Void> execute(String threadNamePrefix, Runnable task) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            String threadName = threadNamePrefix + "-0x" + Long.toHexString((long)AbstractCommandExecutor.this.hashCode() & 0xFFFFFFFFL);
            Thread thread = new Thread(() -> {
                try {
                    task.run();
                    future.complete(null);
                }
                catch (Throwable cause) {
                    future.completeExceptionally(cause);
                }
            }, threadName);
            thread.start();
            return future;
        }
    }
}

