/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionRange;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Throwables;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableFindCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableFindLatestRevCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableHistoryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableMergeQueryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableMultiDiffCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableQueryCall;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CacheableSingleDiffCall;
import com.linecorp.centraldogma.server.storage.StorageException;
import com.linecorp.centraldogma.server.storage.project.Project;
import com.linecorp.centraldogma.server.storage.repository.FindOption;
import com.linecorp.centraldogma.server.storage.repository.FindOptions;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

final class CachingRepository
implements Repository {
    private static final CancellationException CANCELLATION_EXCEPTION = (CancellationException)Exceptions.clearTrace((Throwable)new CancellationException("watch cancelled by caller"));
    private final Repository repo;
    private final RepositoryCache cache;
    private final Commit firstCommit;

    CachingRepository(Repository repo, RepositoryCache cache) {
        this.repo = Objects.requireNonNull(repo, "repo");
        this.cache = Objects.requireNonNull(cache, "cache");
        try {
            List<Commit> history = repo.history(Revision.INIT, Revision.INIT, "/**", 1).join();
            this.firstCommit = history.get(0);
        }
        catch (CompletionException e) {
            Throwable cause = Exceptions.peel((Throwable)e);
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new StorageException("failed to retrieve the initial commit", cause);
        }
    }

    @Override
    public long creationTimeMillis() {
        return this.firstCommit.when();
    }

    @Override
    public Author author() {
        return this.firstCommit.author();
    }

    @Override
    public <T> CompletableFuture<Entry<T>> getOrNull(Revision revision, Query<T> query) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        Revision normalizedRevision = this.normalizeNow(revision);
        if (query.type() == QueryType.IDENTITY) {
            String path = query.path();
            CompletionStage future = this.find(revision, path, FindOptions.FIND_ONE_WITH_CONTENT).thenApply(findResult -> (Entry)findResult.get(path));
            return (CompletableFuture)Util.unsafeCast((Object)future);
        }
        CompletionStage future = this.cache.get(new CacheableQueryCall(this.repo, normalizedRevision, query)).thenApply(result -> result != CacheableQueryCall.EMPTY ? result : null);
        return (CompletableFuture)Util.unsafeCast((Object)future);
    }

    @Override
    public CompletableFuture<Map<String, Entry<?>>> find(Revision revision, String pathPattern, Map<FindOption<?>, ?> options) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        Objects.requireNonNull(options, "options");
        Revision normalizedRevision = this.normalizeNow(revision);
        return this.cache.get(new CacheableFindCall(this.repo, normalizedRevision, pathPattern, options));
    }

    @Override
    public CompletableFuture<List<Commit>> history(Revision from, Revision to, String pathPattern, int maxCommits) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        if (maxCommits <= 0) {
            throw new IllegalArgumentException("maxCommits: " + maxCommits + " (expected: > 0)");
        }
        RevisionRange range = this.normalizeNow(from, to);
        int actualMaxCommits = Math.min(maxCommits, Math.abs(range.from().major() - range.to().major()) + 1);
        return this.cache.get(new CacheableHistoryCall(this.repo, range.from(), range.to(), pathPattern, actualMaxCommits));
    }

    @Override
    public CompletableFuture<Change<?>> diff(Revision from, Revision to, Query<?> query) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(query, "query");
        RevisionRange range = this.normalizeNow(from, to).toAscending();
        return this.cache.get(new CacheableSingleDiffCall(this.repo, range.from(), range.to(), query));
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> diff(Revision from, Revision to, String pathPattern) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        Objects.requireNonNull(pathPattern, "pathPattern");
        RevisionRange range = this.normalizeNow(from, to).toAscending();
        return this.cache.get(new CacheableMultiDiffCall(this.repo, range.from(), range.to(), pathPattern));
    }

    @Override
    public CompletableFuture<Revision> findLatestRevision(Revision lastKnownRevision, String pathPattern) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        RevisionRange range = this.normalizeNow(lastKnownRevision, Revision.HEAD);
        if (range.from().equals((Object)range.to())) {
            return CompletableFuture.completedFuture(null);
        }
        return this.cache.get(new CacheableFindLatestRevCall(this.repo, range.from(), range.to(), pathPattern)).thenApply(result -> result != CacheableFindLatestRevCall.EMPTY ? result : null);
    }

    @Override
    public CompletableFuture<Revision> watch(Revision lastKnownRevision, String pathPattern) {
        Objects.requireNonNull(lastKnownRevision, "lastKnownRevision");
        Objects.requireNonNull(pathPattern, "pathPattern");
        CompletableFuture<Revision> latestRevFuture = this.findLatestRevision(lastKnownRevision, pathPattern);
        if (latestRevFuture.isCompletedExceptionally() || latestRevFuture.getNow(null) != null) {
            return latestRevFuture;
        }
        CompletableFuture<Revision> future = new CompletableFuture<Revision>();
        latestRevFuture.whenComplete((latestRevision, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
                return;
            }
            if (latestRevision != null) {
                future.complete((Revision)latestRevision);
                return;
            }
            CompletableFuture<Revision> watchFuture = this.repo.watch(lastKnownRevision, pathPattern);
            watchFuture.whenComplete((watchResult, watchCause) -> {
                if (watchCause == null) {
                    future.complete((Revision)watchResult);
                } else {
                    future.completeExceptionally((Throwable)watchCause);
                }
            });
            future.whenComplete((unused1, unused2) -> watchFuture.completeExceptionally(CANCELLATION_EXCEPTION));
        });
        return future;
    }

    @Override
    public Project parent() {
        return this.repo.parent();
    }

    @Override
    public String name() {
        return this.repo.name();
    }

    @Override
    public Revision normalizeNow(Revision revision) {
        return this.repo.normalizeNow(revision);
    }

    @Override
    public RevisionRange normalizeNow(Revision from, Revision to) {
        return this.repo.normalizeNow(from, to);
    }

    @Override
    public CompletableFuture<Map<String, Change<?>>> previewDiff(Revision baseRevision, Iterable<Change<?>> changes) {
        Objects.requireNonNull(baseRevision, "baseRevision");
        return this.repo.previewDiff(baseRevision, changes);
    }

    @Override
    public CompletableFuture<Revision> commit(Revision baseRevision, long commitTimeMillis, Author author, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        return this.repo.commit(baseRevision, commitTimeMillis, author, summary, detail, markup, changes);
    }

    @Override
    public <T> CompletableFuture<MergedEntry<T>> mergeFiles(Revision revision, MergeQuery<T> query) {
        Objects.requireNonNull(revision, "revision");
        Objects.requireNonNull(query, "query");
        Revision normalizedRevision = this.normalizeNow(revision);
        CacheableMergeQueryCall key = new CacheableMergeQueryCall(this.repo, normalizedRevision, query);
        CompletableFuture value = this.cache.getIfPresent(key);
        if (value != null) {
            return (CompletableFuture)Util.unsafeCast(value);
        }
        return Repository.super.mergeFiles(normalizedRevision, query).thenApply(mergedEntry -> {
            key.computedValue((MergedEntry<?>)mergedEntry);
            this.cache.get(key);
            return mergedEntry;
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("repo", (Object)this.repo).add("firstCommit", (Object)this.firstCommit).toString();
    }
}

