/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public final class QueryRequestConverter
implements RequestConverterFunction {
    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpRequest request, Class<?> expectedResultType) throws Exception {
        String path = QueryRequestConverter.getPath(ctx);
        Optional<Iterable<String>> jsonPaths = QueryRequestConverter.getJsonPaths(ctx);
        if (jsonPaths.isPresent()) {
            return Optional.of(Query.ofJsonPath((String)path, jsonPaths.get()));
        }
        if (Util.isValidFilePath((String)path)) {
            return Optional.of(Query.of((QueryType)QueryType.IDENTITY, (String)path, (String[])new String[0]));
        }
        return Optional.empty();
    }

    private static String getPath(ServiceRequestContext ctx) {
        List params;
        String path = ctx.pathParam("path");
        if (!Strings.isNullOrEmpty((String)path)) {
            return path;
        }
        String query = ctx.query();
        if (query != null && (params = (List)new QueryStringDecoder(query, false).parameters().get("path")) != null) {
            return (String)params.get(0);
        }
        return "";
    }

    private static Optional<Iterable<String>> getJsonPaths(ServiceRequestContext ctx) {
        List jsonPaths;
        String query = ctx.query();
        if (query != null && (jsonPaths = (List)new QueryStringDecoder(query, false).parameters().get("jsonpath")) != null) {
            return Optional.of(ImmutableList.copyOf((Collection)jsonPaths));
        }
        return Optional.empty();
    }
}

