/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergeSource;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.internal.storage.repository.CacheableCall;
import com.linecorp.centraldogma.server.storage.repository.Repository;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

final class CacheableMergeQueryCall
extends CacheableCall<MergedEntry<?>> {
    private final Revision revision;
    private final MergeQuery<?> query;
    private final int hashCode;
    @Nullable
    MergedEntry<?> computedValue;

    CacheableMergeQueryCall(Repository repo, Revision revision, MergeQuery<?> query) {
        super(repo);
        this.revision = Objects.requireNonNull(revision, "revision");
        this.query = Objects.requireNonNull(query, "query");
        query.mergeSources().forEach(path -> Util.validateJsonFilePath((String)path.path(), (String)"path"));
        this.hashCode = Objects.hash(revision, query) * 31 + System.identityHashCode(repo);
        assert (!revision.isRelative());
    }

    @Override
    protected int weigh(MergedEntry<?> value) {
        int weight = 0;
        List mergeSources = this.query.mergeSources();
        weight += mergeSources.size();
        for (MergeSource mergeSource : mergeSources) {
            weight += mergeSource.path().length();
        }
        List expressions = this.query.expressions();
        weight += expressions.size();
        for (String expression : expressions) {
            weight += expression.length();
        }
        if (value != null) {
            weight += value.contentAsText().length();
        }
        return weight;
    }

    @Override
    public CompletableFuture<MergedEntry<?>> execute() {
        Preconditions.checkState((this.computedValue != null ? 1 : 0) != 0, (Object)"computedValue is not set yet.");
        return CompletableFuture.completedFuture(this.computedValue);
    }

    void computedValue(MergedEntry<?> computedValue) {
        Preconditions.checkState((this.computedValue == null ? 1 : 0) != 0, (Object)"computedValue is already set.");
        this.computedValue = Objects.requireNonNull(computedValue, "computedValue");
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CacheableMergeQueryCall that = (CacheableMergeQueryCall)o;
        return this.revision.equals((Object)that.revision) && this.query.equals(that.query);
    }

    @Override
    protected void toString(MoreObjects.ToStringHelper helper) {
        helper.add("revision", (Object)this.revision).add("query", this.query);
    }
}

