/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpApiUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiUtil.class);
    static final JsonNode unremoveRequest = Jackson.valueToTree((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"op", (Object)"replace", (Object)"path", (Object)"/status", (Object)"value", (Object)"active")));

    public static <T> T throwResponse(RequestContext ctx, HttpStatus status, String message) {
        throw HttpResponseException.of((HttpResponse)HttpApiUtil.newResponse(ctx, status, message));
    }

    public static <T> T throwResponse(RequestContext ctx, HttpStatus status, String format, Object ... args) {
        throw HttpResponseException.of((HttpResponse)HttpApiUtil.newResponse(ctx, status, format, args));
    }

    public static <T> T throwResponse(RequestContext ctx, HttpStatus status, Throwable cause, String message) {
        throw HttpResponseException.of((HttpResponse)HttpApiUtil.newResponse(ctx, status, cause, message));
    }

    public static <T> T throwResponse(RequestContext ctx, HttpStatus status, Throwable cause, String format, Object ... args) {
        throw HttpResponseException.of((HttpResponse)HttpApiUtil.newResponse(ctx, status, cause, format, args));
    }

    public static HttpResponse newResponse(RequestContext ctx, HttpStatus status, String format, Object ... args) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return HttpApiUtil.newResponse(ctx, status, String.format(Locale.ENGLISH, format, args));
    }

    public static HttpResponse newResponse(RequestContext ctx, HttpStatus status, String message) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(message, "message");
        return HttpApiUtil.newResponse0(ctx, status, null, message);
    }

    public static HttpResponse newResponse(RequestContext ctx, HttpStatus status, Throwable cause) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(cause, "cause");
        return HttpApiUtil.newResponse0(ctx, status, cause, null);
    }

    public static HttpResponse newResponse(RequestContext ctx, HttpStatus status, Throwable cause, String format, Object ... args) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(cause, "cause");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return HttpApiUtil.newResponse(ctx, status, cause, String.format(Locale.ENGLISH, format, args));
    }

    public static HttpResponse newResponse(RequestContext ctx, HttpStatus status, Throwable cause, String message) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(cause, "cause");
        Objects.requireNonNull(message, "message");
        return HttpApiUtil.newResponse0(ctx, status, cause, message);
    }

    private static HttpResponse newResponse0(RequestContext ctx, HttpStatus status, @Nullable Throwable cause, @Nullable String message) {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        if (cause != null) {
            node.put("exception", cause.getClass().getName());
            if (message == null) {
                message = cause.getMessage();
            }
        }
        String m = Strings.nullToEmpty((String)message);
        node.put("message", m);
        if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
            if (cause != null) {
                if (!(cause instanceof ShuttingDownException) && !(cause instanceof AbortedStreamException)) {
                    logger.warn("{} Returning an internal server error: {}", new Object[]{ctx, m, cause});
                }
            } else {
                logger.warn("{} Returning an internal server error: {}", (Object)ctx, (Object)m);
            }
        } else if (status == HttpStatus.CONFLICT && !(cause instanceof RedundantChangeException)) {
            logger.warn("{} Returning a conflict: {}", new Object[]{ctx, m, cause});
        } else if (status == HttpStatus.BAD_REQUEST && cause instanceof QueryExecutionException) {
            logger.warn("{} Returning a bad request: {}", new Object[]{ctx, m, cause});
        }
        try {
            return HttpResponse.of((HttpStatus)status, (MediaType)MediaType.JSON_UTF_8, (byte[])Jackson.writeValueAsBytes((Object)node));
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    static void checkUnremoveArgument(JsonNode node) {
        Preconditions.checkArgument((boolean)unremoveRequest.equals((Object)node), (Object)("Unsupported JSON patch: " + node + " (expected: " + unremoveRequest + ')'));
    }

    static void checkStatusArgument(String status) {
        Preconditions.checkArgument((boolean)"removed".equalsIgnoreCase(status), (Object)("invalid status: " + status + " (expected: removed)"));
    }

    static Void throwUnsafelyIfNonNull(@Nullable Object unused, @Nullable Throwable cause) {
        HttpApiUtil.throwUnsafelyIfNonNull(cause);
        return null;
    }

    static void throwUnsafelyIfNonNull(@Nullable Throwable cause) {
        if (cause != null) {
            Exceptions.throwUnsafely((Throwable)cause);
        }
    }

    static <T, U> BiFunction<? super T, Throwable, ? extends U> returnOrThrow(Supplier<? super U> supplier) {
        return (unused, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return supplier.get();
        };
    }

    static <T, U> BiFunction<? super T, Throwable, ? extends U> returnOrThrow(Function<? super T, ? extends U> function) {
        return (result, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return function.apply(result);
        };
    }

    private HttpApiUtil() {
    }
}

