/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingService;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.RequiresRole;
import com.linecorp.centraldogma.server.metadata.MetadataService;
import com.linecorp.centraldogma.server.metadata.MetadataServiceInjector;
import com.linecorp.centraldogma.server.metadata.ProjectRole;
import com.linecorp.centraldogma.server.metadata.User;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class RequiresRoleDecorator
extends SimpleDecoratingService<HttpRequest, HttpResponse> {
    private final Set<ProjectRole> accessibleRoles;
    private final String roleNames;

    RequiresRoleDecorator(Service<HttpRequest, HttpResponse> delegate, Set<ProjectRole> accessibleRoles) {
        super(delegate);
        this.accessibleRoles = ImmutableSet.copyOf((Collection)Objects.requireNonNull(accessibleRoles, "accessibleRoles"));
        this.roleNames = String.join((CharSequence)",", (Iterable)accessibleRoles.stream().map(Enum::name).collect(ImmutableList.toImmutableList()));
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        MetadataService mds = MetadataServiceInjector.getMetadataService(ctx);
        User user = AuthUtil.currentUser(ctx);
        String projectName = ctx.pathParam("projectName");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"no project name is specified");
        try {
            return HttpResponse.from((CompletionStage)mds.findRole(projectName, user).handle((role, cause) -> {
                if (cause != null) {
                    return RequiresRoleDecorator.handleException(ctx, cause);
                }
                if (!user.isAdmin() && !this.accessibleRoles.contains(role)) {
                    return (HttpResponse)HttpApiUtil.throwResponse((RequestContext)ctx, HttpStatus.FORBIDDEN, "You must have one of the following roles to access the project '%s': %s", projectName, this.roleNames);
                }
                try {
                    return (HttpResponse)this.delegate().serve(ctx, (Request)req);
                }
                catch (Exception e) {
                    return (HttpResponse)Exceptions.throwUnsafely((Throwable)e);
                }
            }));
        }
        catch (Throwable cause2) {
            return RequiresRoleDecorator.handleException(ctx, cause2);
        }
    }

    static HttpResponse handleException(ServiceRequestContext ctx, Throwable cause) {
        if ((cause = Exceptions.peel((Throwable)cause)) instanceof RepositoryNotFoundException || cause instanceof ProjectNotFoundException) {
            return HttpApiUtil.newResponse((RequestContext)ctx, HttpStatus.NOT_FOUND, cause);
        }
        return (HttpResponse)Exceptions.throwUnsafely((Throwable)cause);
    }

    public static final class RequiresRoleDecoratorFactory
    implements DecoratorFactoryFunction<RequiresRole> {
        public Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> newDecorator(RequiresRole parameter) {
            return delegate -> new RequiresRoleDecorator((Service<HttpRequest, HttpResponse>)delegate, (Set<ProjectRole>)ImmutableSet.copyOf((Object[])parameter.roles()));
        }
    }
}

