/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.auth.OAuth2Token;
import com.linecorp.centraldogma.server.internal.admin.auth.AuthUtil;
import com.linecorp.centraldogma.server.metadata.Token;
import com.linecorp.centraldogma.server.metadata.Tokens;
import com.linecorp.centraldogma.server.metadata.UserWithToken;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTokenAuthorizer
implements Authorizer<HttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationTokenAuthorizer.class);
    private final Function<String, CompletionStage<Token>> tokenLookupFunc;

    public ApplicationTokenAuthorizer(Function<String, CompletionStage<Token>> tokenLookupFunc) {
        this.tokenLookupFunc = Objects.requireNonNull(tokenLookupFunc, "tokenLookupFunc");
    }

    public CompletionStage<Boolean> authorize(ServiceRequestContext ctx, HttpRequest data) {
        OAuth2Token token = (OAuth2Token)AuthTokenExtractors.OAUTH2.apply(data.headers());
        if (token == null || !Tokens.isValidSecret(token.accessToken())) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> res = new CompletableFuture<Boolean>();
        this.tokenLookupFunc.apply(token.accessToken()).thenAccept(appToken -> {
            if (appToken != null && appToken.isActive()) {
                StringBuilder login = new StringBuilder(appToken.appId());
                SocketAddress ra = ctx.remoteAddress();
                if (ra instanceof InetSocketAddress) {
                    login.append('@').append(((InetSocketAddress)ra).getHostString());
                }
                AuthUtil.setCurrentUser(ctx, new UserWithToken(login.toString(), (Token)appToken));
                res.complete(true);
            } else {
                res.complete(false);
            }
        }).exceptionally(Functions.voidFunction(cause -> {
            if (!((cause = Exceptions.peel((Throwable)cause)) instanceof IllegalArgumentException)) {
                logger.warn("Application token authorization failed: {}", (Object)token.accessToken(), cause);
            }
            res.complete(false);
        }));
        return res;
    }
}

